<?php

namespace Internetgalerie\Flipbook\Controller;

use TYPO3\CMS\Core\Resource\FileRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;

class FlipbookController extends ActionController
{
    protected ?ContentObjectRenderer $contentObj;

    public function __construct(
        private readonly FileRepository $fileRepository,
    ) {}

    public function listAction(): ResponseInterface
    {
        $currentContentObject = $this->request->getAttribute('currentContentObject');
        if ($currentContentObject !== null) {
            $uid = $currentContentObject->data['uid'] ?? null;
            $pdfFile = $this->fileRepository->findByRelation('tt_content', 'settings.pdfFile', $uid);
            $this->view->assign('pdfFile', $pdfFile[0]);
            if ($this->settings['thumbnail']) {
                $thumbnail = $this->fileRepository->findByRelation('tt_content', 'settings.thumbnail', $uid);
                $this->view->assign('thumbnail', $thumbnail[0]);
            }
        }
        return $this->htmlResponse();
    }
}
