document.addEventListener('DOMContentLoaded', () => {
    const pdfLightboxTriggers = document.querySelectorAll('.ig-lightbox-book-container');
    // if (!isResponsive()) {
    pdfLightboxTriggers.forEach(triggerElement => {
        triggerElement.addEventListener('click', async (e) => {
            e.preventDefault();
            triggerElement.classList.add('loading');
            if (triggerElement.pdfToLightBoxConverterInstance) {
                triggerElement.pdfToLightBoxConverterInstance.open();
                triggerElement.classList.remove('loading');
                return;
            }
            const libsString = triggerElement.dataset.libs;
            if (!libsString) {
                console.error('Missing data-libs attribute on container. Cannot load PDF viewer modules.');
                triggerElement.classList.remove('loading');
                return;
            }
            try {
                if (typeof PdfToLightBoxConverter === 'undefined') {
                    const importPromises = libsString.split(',').map(path => import(path.trim()));
                    await Promise.all(importPromises);
                }
                triggerElement.pdfToLightBoxConverterInstance = new PdfToLightBoxConverter({
                    container: triggerElement,
                    source: triggerElement.href
                });
                triggerElement.classList.remove('loading');
            } catch (error) {
                console.error('Failed to load or instantiate PdfToLightBoxConverter:', error);
            }
        });
    });
    // }
});
