<?php

namespace Ig\IgAccordion\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;


class HashIdViewHelper extends AbstractViewHelper
{
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        $this->registerArgument('header', 'string', 'Element Header', false);
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $header = $arguments['header'];
        // Replace umlauts
        $header = str_replace("ä", "ae", $header);
        $header = str_replace("Ä", "ae", $header);
        $header = str_replace("ö", "oe", $header);
        $header = str_replace("Ö", "oe", $header);
        $header = str_replace("ü", "ue", $header);
        $header = str_replace("Ü", "ue", $header);

        // Remove non-alphanumeric characters and convert to lowercase
        $header = preg_replace("/[^a-z0-9-\s]/i", "", $header);
        $header = strtolower($header);

        // Replace multiple spaces or hyphens with a single hyphen
        $header = preg_replace("/[\s-]+/", "-", $header);

        // Remove trailing hyphen
        $header = rtrim($header, "-");

        return $header;
    }
}
