/**
 *************************************
 * jquery.accordion.js
 *
 *************************************
 * @author    : internetgalerie
 *************************************
 * Changelog
 *
 * SK | 13.02.2018 | Add option to enable scrolling after opening.
 * FS | 16.01.2017 | no window load / URL Hash changes / logic less lose
 * FS | 03.02.2015 | Add Table & is-open
 * FS | 29.01.2015 | First Beta Release
 */
jQuery(function($) {
    $(document).ready(function() {
        var tar;
        var oldTar;
        var urlHash = window.location.hash;
        //initializeClasses();
        $('.ig-accordion > div > :first-child').click(function(e) {
            // get the click target
            tar = e.target;

            // get the parent of clicked element
            var $parentTar = $(this).parent().parent();

            // set hash with pregenerated title
            if($($parentTar).attr('data-hashid')) {
                window.location.hash = $($parentTar).attr('data-hashid');
            }

            // Get the option for scrolling
            var enableAccordionScrolling = !!Accordion.enableScrolling;
            var dataEnableScrolling = $parentTar.data('enableAccordionScrolling');

            if(dataEnableScrolling == '0' || dataEnableScrolling == '') {
                enableAccordionScrolling = false;
            }

            /* the tricky part!
             *
             * if clicked twice toggle normally (without closeAll)
             *
             * IF is open -> close
             *
             * ELSE
             * closeAll (if activated in constants) and open
             *
             */
            classname = $('html').hasClass('.touch') ? 'mobile' : 'desktop';

            // Falls gleiches Accordion geklickt wird nur toggle -> falls sub Accordion vorhanden, ist dies immer noch offen - sonst fuer nix
            if (oldTar == tar) {
                $parentTar.toggleClass('is-open');
            } else {
                if ($parentTar.hasClass('is-open') || $parentTar.hasClass(classname + '1')) {
                    $parentTar.removeClass('is-open').removeClass('desktop1').removeClass('mobile1');
                } else {
                    if (Accordion.closeOther != '0' && $parentTar.data('closeOther') != '0') {
                        closeAll($parentTar.parent().parent());
                    }
                    $parentTar.addClass('is-open').removeClass('desktop0').removeClass('mobile0');
                }
            }
            // set the clicked tar into another variable
            oldTar = tar;

            $(window).resize();
            // if google Analytics is active on page and constant is set
            if ( typeof gaEventActive != 'undefined') {
                var title = $(this).find(':header').first().text();

                var gaSettings = {
                    hitType : 'event',
                    eventCategory : 'Accordion',
                    eventLabel : title
                }

                gaSettings.eventAction = $parentTar.hasClass('is-open') ? 'show' : 'hide';
                ga('send', gaSettings);
            }

            // Scroll to top if enabled
            if (enableAccordionScrolling) {
                // Add the height of the header on desktop if it's shown
                var scrollTop = $(this).offset().top - getExtraHeight();
                setTimeout(function() {
                    $('html, body').animate({
                        scrollTop : scrollTop
                    });
                }, 50);
            }
        });
	function getExtraHeight() {
        var windowWidth = $(window).outerWidth();
        if (windowWidth > breakpoint && ($('html').hasClass('scrollHeader') || $('.scrollHeader').length || $('#header').css("position") === "fixed" || $('#header .accordion-scroll-header-height').length)) {
            if($('#header .accordion-scroll-header-height').length) {
                return $('#header .accordion-scroll-header-height').outerHeight();
            }
            return $('#header').height();
        } else {
        // Mobile only when scrolling up
            if (windowWidth <= breakpoint) {
                if($('#header .accordion-scroll-header-height-responsive').length) {
                    return $('#header .accordion-scroll-header-height-responsive').outerHeight();
                }
    			if( $('#header').css("position") === "fixed" ) {
    			   return $('#header').height();
    			} else {
    			    if ($('#header').hasClass('fixedBlock')) {
        				var windowOffset = $(window).scrollTop();
        				if (windowOffset >= $(this).offset().top) {
        				    return $('#header').height();
        				}
    			    }
    			}
            }
        }
        return 0;
    }


        /* closeAll function
         * if activated in the constants it goes throght the
         * whole html DOM and close removes the accordion-show from it.
         */
        function closeAll($parentTar) {
        	var $accordions = $($parentTar).parent();

        	if($accordions.hasClass('ig-flow-row')) {
        		$accordions = $($parentTar).parent().parent();
        	}
            $accordions.find('.ig-accordion').each(function() {
                $(this).removeClass('is-open').removeClass('desktop1').removeClass('mobile1');
            });
        }

        // sets the generated hash in every ig-accordion Element
        function generateHashId() {
            $('.ig-accordion').each(function() {
                element = $(this);
                elementHeader = $(this).find(':header').first().text();
                if(!$(this).data('hashid')) {
                	$(this).attr('data-hashid', preparedHeaderId(elementHeader));
                }
                // set additional class if it has accordion children
                $(this).addClass(($(this).find('.ig-accordion > div').length ? 'ig-has-accordion-children' : ''));
            });
        }

        /*
         *  replaces everything except - a-z äöü (case sensitive)
         *  tab, whitespace, newline to -
         *  if dash is last, remove
         *  ä to ae, ö to oe and ü to ue
         *  forced to lower case
         */
        function preparedHeaderId(elementHeader) {
            return elementHeader.trim().replace(/[^a-z0-9äöü-\s]/gi, '').replace(/\s+/g, '-').replace(/[äÄ]/g, "ae").replace(/[öÖ]/g, "oe").replace(/[üÜ]/g, "ue").replace(/\-+/g, '-').replace(/\-$/, '').toLowerCase();
        }

        // generate has for url
        generateHashId();
        // only called if urlHash != open accordion
        if (urlHash && urlHash.replace("#", '') && urlHash.replace("#", '') != $('.ig-accordion.is-open').attr('data-hashid')) {
            $hashElement = $('.ig-accordion[data-hashid="' + urlHash.replace("#", '') + '"]  .inner-frame');
	    if( $hashElement.length>0 ) {
		$hashElement.children().first().click();
            } else {
		$hashElement = $('.ig-accordion[id="' + urlHash.replace("#", '') + '"] .inner-frame');
		if( $hashElement.length>0) {
		    $hashElement.children().first().click();
		}
	    }
	    if( $hashElement.length>0 ) {
            var enableAccordionScrolling = !!Accordion.enableScrolling;
            var dataEnableScrolling = !!$hashElement.parent().data('enableAccordionScrolling');

            if(dataEnableScrolling == '0') {
                enableAccordionScrolling = false;
            }

            if(enableAccordionScrolling) {
        		var scrollTop = $hashElement.offset().top - getExtraHeight();
        		setTimeout(function() {
        		    $('html, body').animate({
        			scrollTop : scrollTop
        		    });
        		}, 50);
    	    }
        }
	}

    // go to hash item on internal page click
    $(window).on("hashchange.igAccordion", function () {
        var urlHash = window.location.hash;
	$hashElement = $('.ig-accordion[id="' + urlHash.replace("#", '') + '"] .inner-frame');
	if(urlHash && urlHash.replace("#", '') && $hashElement.length>0) {
            $hashElement.children().first().click();
            var enableAccordionScrolling = !!Accordion.enableScrolling;
            var dataEnableScrolling = !!$hashElement.parent().data('enableAccordionScrolling');

            if(dataEnableScrolling == '0') {
                enableAccordionScrolling = false;
            }

            if(enableAccordionScrolling) {
                var scrollTop = $hashElement.offset().top - getExtraHeight();
                setTimeout(function() {
                    $('html, body').animate({
                        scrollTop : scrollTop
                    });
                }, 50);
            }
        }
    });
    });
});
