/*
 *************************************
 * jquery.accordion.js
 * Menu Accordion
 *************************************
 */
class AccordionHandler {
    constructor(config) {
        this.defaultConfig = {};
        this.defaultConfig.mainSelectorClassName = "ig-accordion";
        this.defaultConfig.elements = document.getElementsByClassName(this.defaultConfig.mainSelectorClassName);
        this.defaultConfig.hasChildrenClassName = "ig-has-accordion-children";
        this.defaultConfig.headerElements = "h1, h2, h3, h4, h5, h6";
        this.defaultConfig.toggleClass = "is-open";
        this.defaultConfig.clickArea = document.querySelectorAll("." + this.defaultConfig.mainSelectorClassName + " > div > :first-child");
        this.config = { ...this.defaultConfig, ...config };
        this.config.htmlTag = document.querySelector("html");
        this.config.urlHash = window.location.hash;
        this.config.inAccordion = false;
        this.config.tar = null;
        this.config.oldTar = null;
        this.config.parentTarget = null;
        this.handlers = [];
        this.afterOpen = new Set([]);
        this.init();
    }
    init() {
        // replace desktop1/mobile1 with is-open + aria
        this.setExpandedOnLoad();
        // if url has a hash, scroll to element
        this.scrollToUrlHash();
        for (let i = 0; i < this.config.clickArea.length; i++) {
            let el = this.config.clickArea[i];
            if (this.handlers.includes(el)) continue;
            el.addEventListener("click", (e) => {
                this.handleAccordionEvent(e.target);
            });
            this.handlers.push(el);
        }
        document.addEventListener("focusin", (e) => {
            if (e.target.closest("." + this.config.mainSelectorClassName)) {
                this.config.inAccordion = true;
            } else {
                this.config.inAccordion = false;
            }
        });
        document.addEventListener("keyup", (e) => {
            let target = e.target.querySelector(this.config.headerElements);
            if (
                (e.code == "Tab" &&
                    e.target.classList.contains(this.config.mainSelectorClassName) > 0 &&
                    e.target.getAttribute("aria-expanded") === "false") ||
                ((e.code == "Space" || e.code == "Enter") && this.config.inAccordion)
            ) {
                this.handleAccordionEvent(target);
            }
        });
    }
    update() {
        this.config.clickArea = document.querySelectorAll("." + this.config.mainSelectorClassName + " > div > :first-child");
        this.init();
        return this;
    }
    // check on accordion in accordion
    setAccordionInAccordionClass() {
        let igAccordion = this.defaultConfig.elements;
        for (let i = 0; i < this.defaultConfig.elements.length; i++) {
            if (igAccordion[i].querySelector("." + this.config.mainSelectorClassName)) {
                igAccordion[i].classList.add(this.config.hasChildrenClassName);
            }
        }
    }
    scrollToUrlHash() {
        let tagName = this.config.urlHash.replace("#", "");
        let currentAccordion = document.querySelector("[data-hash-id='" + tagName + "']");
        if (this.config.urlHash && currentAccordion) {
            this.closeAll(currentAccordion);
            // set self active
            this.handleAccordionEvent(currentAccordion.querySelector(this.config.headerElements), true);
        }
    }
    handleAccordionEvent(element, onLoad = false) {
        // get the click target
        this.config.tar = element;
        // get the parent of clicked element
        this.parentTarget = this.config.tar.closest("." + this.config.mainSelectorClassName);
        // set hash with generated title
        if (this.parentTarget.getAttribute("data-hash-id")) {
            window.location.hash = this.parentTarget.getAttribute("data-hash-id");
        }
        // Get the option for scrolling
        let enableAccordionScrolling = typeof Accordion !== 'undefined' ?  !!Accordion.enableScrolling : false;
        let dataEnableScrolling = this.parentTarget.dataset.enableAccordionScrolling;

        if (dataEnableScrolling == '0' || dataEnableScrolling == '') {
            enableAccordionScrolling = false;
        }
        if (
            this.config.oldTar == this.config.tar ||
            (onLoad == false && this.parentTarget.classList.contains(this.config.toggleClass))
        ) {
            // toggle self
            this.parentTarget.classList.toggle(this.config.toggleClass);
        } else {
            // close all if set in constants
            if (this.parentTarget.dataset.closeOther != "0") {
                this.closeAll(this.config.tar);
            }
            // open selected + parents
            this.parentTarget.classList.add(this.config.toggleClass);
        }
        // check aria expanded status
        this.ariaCheck(this.parentTarget);
        // copy target to persistent var
        this.config.oldTar = this.config.tar;
	// @todo only after open
        this.afterOpen.forEach((afterOpen) => {
                 afterOpen(this);
        });

        // if google Analytics is active on page and constant is set
        // ##FS##: not tested
        if (typeof gaEventActive != "undefined") {
            var title = this.config.tar.innerHTML;
            var gaSettings = {
                hitType: "event",
                eventCategory: "Accordion",
                eventLabel: title,
            };
            gaSettings.eventAction = this.parentTarget.classList.contains(this.config.toggleClass) ? "show" : "hide";
            ga("send", gaSettings);
        }

        // Scroll to top if enabled
        if (enableAccordionScrolling) {
            this.scrollEvent();
        }
    }
    // set aria expanded if accordion active
    ariaCheck(element) {
        if (element.classList.contains(this.config.toggleClass)) {
            element.setAttribute("aria-expanded", true);
        } else {
            element.setAttribute("aria-expanded", false);
        }
    }
    // set expanded status on load
    setExpandedOnLoad() {
        let accordions = this.defaultConfig.elements;
        let expanded = false;
        for (let i = 0; i < accordions.length; i++) {
            expanded = false;
            if (accordions[i].classList.contains("desktop0") && accordions[i].classList.contains("mobile0")) {
                accordions[i].classList.remove("mobile0", "desktop0");
                continue;
            } else {
                if (
                    (this.config.htmlTag.classList.contains("touch") && accordions[i].classList.contains("mobile1")) ||
                    (this.config.htmlTag.classList.contains("no-touch") && accordions[i].classList.contains("desktop1"))
                ) {
                    expanded = true;
                }
                if (expanded) {
                    accordions[i].classList.add(this.config.toggleClass);
                    this.ariaCheck(accordions[i]);
                }
                accordions[i].classList.remove("mobile0", "desktop0");
                accordions[i].classList.remove("mobile1", "desktop1");
            }
        }
    }
    // close all
    closeAll(element) {
        if (typeof Accordion !== 'undefined' && Accordion.closeOther != "0") {
            let children = this.defaultConfig.elements;
            for (let i = 0; i < children.length; i++) {
                children[i].classList.remove(this.config.toggleClass);
                this.ariaCheck(children[i]);
            }
        }
        // set parent active
        this.openParents(element);
    }
    // open parents of current
    openParents(element) {
        let parents = getParents(element, "." + this.config.mainSelectorClassName);
        // set parents active + aria
        for (let i = 0; i < parents.length; i++) {
            parents[i].classList.add(this.config.toggleClass);
            this.ariaCheck(parents[i]);
        }
    }
    // get headerHeight when position is fixed
    getExtraHeight() {
        let header = document.querySelectorAll(Accordion.scrollHeaderElement || "#header");
        if (header.length > 1) {
            console.error("Accordion.scrollHeaderElement: Selector is not precise enough");
        }
        if (getComputedStyle(header[0]).position === "fixed") {
            return outerHeight(header[0]) + Accordion.scrollOffset;
        }
        return 0;
    }
    // scroll scrollIntoView event
    scrollEvent() {
        // Add the height of the header on desktop if shown
        let scrollMargin = parseInt(this.getExtraHeight());
        if (scrollMargin) {
            this.config.tar.parentElement.style.scrollMargin = parseInt(this.getExtraHeight()) + "px";
        }
        this.config.tar.parentElement.scrollIntoView({ behavior: "smooth" });
    }
}
let ig_accordionConfig = {};
ig_accordionConfig.mainSelectorClassName = "ig-accordion";
ig_accordionConfig.elements = document.getElementsByClassName(ig_accordionConfig.mainSelectorClassName);

if (ig_accordionConfig.elements.length > 0) {
    let accordionHandler = new AccordionHandler({ ig_accordionConfig });
    if (typeof window.igJs !== 'undefined') {
        window.igJs.add('AccordionHandler', accordionHandler);
    }
}