<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\ViewHelpers\FrontendUser;

use Internetgalerie\IgAcl\Utility\AclUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class HasRoleViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('context', 'string', 'context to look up', true); //or resource/module
        $this->registerArgument(
            'role',
            'string',
            'is user in given role in group ids in given context (or parent contexts)',
            true
        ); //or resource/module
    }
    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $aclUtility = GeneralUtility::makeInstance(AclUtility::class);
        return $aclUtility->hasRole($arguments['role'], $arguments['context']);
    }
}
