<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUserGroup;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

abstract class AbstractEntityWithAcl extends AbstractEntity implements AclOwnerInterface, AclGroupInterface
{
    /**
     * aclOwner
     *
     * @var int
     */
    public $aclOwner = 0;

    /**
     * aclReadGroups
     *
     * @var ObjectStorage<FrontendUserGroup>
     */
    public $aclReadGroups;

    /**
     * aclWriteGroups
     *
     * @var ObjectStorage<FrontendUserGroup>
     */
    public $aclWriteGroups;

    /**
     * __construct
     */
    public function __construct()
    {
        $this->aclReadGroups = new ObjectStorage();
        $this->aclWriteGroups = new ObjectStorage();
    }

    /**
     * Returns the aclOwner
     *
     * @return integer
     */
    public function getAclOwner()
    {
        return $this->aclOwner;
    }

    /**
     * Sets the aclOwner
     *
     * @param integer $aclOwner
     */
    public function setAclOwner($aclOwner): void
    {
        $this->aclOwner = $aclOwner;
    }


    /**
     * Sets the aclReadGroups. Keep in mind that the property is called "aclReadGroups"
     * although it can hold several aclReadGroups.
     *
     * @param ObjectStorage<FrontendUserGroup> $aclReadGroups
     */
    public function setAclReadGroups(ObjectStorage $aclReadGroups): void
    {
        $this->aclReadGroups = $aclReadGroups;
    }

    /**
     * Adds a  FrontendUserGroup to aclReadGroups
     */
    public function addAclReadGroups(FrontendUserGroup $aclReadGroups): void
    {
        $this->aclReadGroups->attach($aclReadGroups);
    }

    /**
     * Adds a FrontendUserGroup to aclReadGroups (if not already exists)
     */
    public function addAclReadGroupsIfNotContains(FrontendUserGroup $aclReadGroups): void
    {
        if (!$this->aclReadGroups->contains($aclReadGroups)) {
            $this->aclReadGroups->attach($aclReadGroups);
        }
    }

    /**
     * Removes a aclReadGroups from the frontend user
     */
    public function removeAclReadGroups(FrontendUserGroup $aclReadGroups): void
    {
        $this->aclReadGroups->detach($aclReadGroups);
    }

    /**
     * Returns the aclReadGroups
     *
     * @return ObjectStorage<FrontendUserGroup> An object storage containing the aclReadGroups
     */
    public function getAclReadGroups()
    {
        return $this->aclReadGroups;
    }
    
    /**
     * Sets the aclWriteGroups. Keep in mind that the property is called "aclWriteGroups"
     * although it can hold several aclWriteGroups.
     *
     * @param ObjectStorage<FrontendUserGroup> $aclWriteGroups
     */
    public function setAclWriteGroups(ObjectStorage $aclWriteGroups): void
    {
        $this->aclWriteGroups = $aclWriteGroups;
    }

    /**
     * Adds a aclWriteGroups to the frontend user
     */
    public function addAclWriteGroups(FrontendUserGroup $aclWriteGroups): void
    {
        $this->aclWriteGroups->attach($aclWriteGroups);
    }

    /**
     * Adds a FrontendUserGroup to aclWriteGroups (if not already exists)
     */
    public function addAclWriteGroupsIfNotContains(FrontendUserGroup $aclWriteGroups): void
    {
        if (!$this->aclWriteGroups->contains($aclWriteGroups)) {
            $this->aclWriteGroups->attach($aclWriteGroups);
        }
    }

    /**
     * Removes a aclWriteGroups from the frontend user
     */
    public function removeAclWriteGroups(FrontendUserGroup $aclWriteGroups): void
    {
        $this->aclWriteGroups->detach($aclWriteGroups);
    }

    /**
     * Returns the aclWriteGroups
     *
     * @return ObjectStorage<FrontendUserGroup> An object storage containing the aclWriteGroups
     */
    public function getAclWriteGroups()
    {
        return $this->aclWriteGroups;
    }

    public function aclHasViewPermission(array $groups)
    {
        $aclGroupArray = [];
        foreach ($this->aclReadGroups as $group) {
            $aclGroupArray[] = $group->getUid();
        }
        foreach ($groups as $groupId) {
            if (in_array($groupId, $aclGroupArray)) {
                return true;
            }
        }
        return false;
    }

    // public function aclHasViewPermission(array $groups)
    // {
    //     $aclGroupArray = explode(',', $this->aclReadGroups);
    //     foreach ($groups as $groupId) {
    //         if (in_array($groupId, $aclGroupArray)) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    protected function initStorageObjects()
    {
        $this->aclReadGroups ??= new ObjectStorage();
        $this->aclWriteGroups ??= new ObjectStorage();
    }    
}
