<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\ViewHelpers\FrontendUser;

use Internetgalerie\IgAcl\Utility\AclUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class HasPermissionWriteViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('object', 'mixed', 'EntityWithAcl like Time', true);
        $this->registerArgument(
            'context',
            'string',
            'is user in admin groups in context with given name',
            true
        ); //or resource/module
        //    $this->registerArgument('role', 'string', 'role needed for write access, default admin', false, 'admin');
    }

    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $aclUtility = GeneralUtility::makeInstance(AclUtility::class);
        return $aclUtility->hasPermissionWrite($arguments['object'], $arguments['context']);
    }
}
