<?php

namespace Internetgalerie\IgAcl\ViewHelpers\Group;

use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class ContainsViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('needle', ObjectStorage::class, 'aclGroups needle', true);
        $this->registerArgument('haystack', ObjectStorage::class, 'aclGroups haystack', true);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $needle = $arguments['needle'];
        $haystack = $arguments['haystack'];

        if ($needle->count() == 0) {
            return true;
        }

        foreach ($needle as $object) {
            if (!$haystack->contains($object)) {
                return false;
            }
        }
        return true;
    }
}
