<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUserGroup;

interface AclGroupInterface
{
    /**
     * Returns the aclWriteGroups
     *
     * @return ObjectStorage<FrontendUserGroup> An object storage containing the aclWriteGroups
     */
    public function getAclWriteGroups();

    /**
     * Returns the aclReadGroups
     *
     * @return ObjectStorage<FrontendUserGroup> An object storage containing the aclReadGroups
     */
    public function getAclReadGroups();

    /**
     * Adds a FrontendUserGroup to aclReadGroups (if not already exists)
     */
    public function addAclReadGroupsIfNotContains(FrontendUserGroup $aclReadGroups);

    /**
     * Adds a FrontendUserGroup to aclWriteGroups (if not already exists)
     */
    public function addAclWriteGroupsIfNotContains(FrontendUserGroup $aclReadGroups);
}