<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\ViewHelpers\FrontendUser;

use Internetgalerie\IgAcl\Utility\AclUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class HasPermissionReadViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('object', 'mixed', 'like EntityWithAcl or array', true);
        $this->registerArgument(
            'context',
            'string',
            'is user in admin groups in context with given name',
            true
        );
        $this->registerArgument('requiredGroup', 'string', 'required frontendUserGroups', false, null);
        $this->registerArgument('requiredGroups', 'array', 'additional required frontendUserGroups', false, []);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $aclUtility = GeneralUtility::makeInstance(AclUtility::class);
        $requiredGroups = $arguments['requiredGroups'];
        if ($arguments['requiredGroup']) {
            if (!in_array($arguments['requiredGroup'], $requiredGroups)) {
                $requiredGroups[] = $arguments['requiredGroup'];
            }
        }
        return $aclUtility->hasPermissionRead($arguments['object'], $arguments['context'], $requiredGroups);
    }
}
