<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\ViewHelpers\FrontendUser;

use Internetgalerie\IgAcl\Utility\AclUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class HasRoleAdminViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument(
            'context',
            'string',
            'is user in admin groups in context with given name',
            true
        ); //or resource/module
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $aclUtility = GeneralUtility::makeInstance(AclUtility::class);
        return $aclUtility->hasRoleAdmin($arguments['context']);
    }
}
