<?php

declare(strict_types=1);

namespace Internetgalerie\IgAcl\ViewHelpers\FrontendUser;

use Internetgalerie\IgAcl\Utility\AclUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IsOwnerViewHelper extends AbstractConditionViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('object', 'mixed', 'EntityWithAcl like Time', true);
    }

    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $object = $arguments['object'] ?? null;
        $aclUtility = GeneralUtility::makeInstance(AclUtility::class);
        return $aclUtility->isOwner($object);
    }
}
