<?php

namespace Ig\IgAnimation\ViewHelpers;

use TYPO3\CMS\Core\Configuration\Loader\YamlFileLoader;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

class DataViewHelper extends AbstractTagBasedViewHelper
{

  
    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('collection', 'string', 'Collection name', false, 'animations');
        $this->registerArgument('id', 'string', 'ID of Animation', false);
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render()
    {
        $yamlUtility=GeneralUtility::makeInstance(\Ig\IgAnimation\Utility\YamlUtility::class);
        $data='';
      
        if ($entry=$yamlUtility->getCollectionEntryById($this->arguments['collection'], $this->arguments['id'])) {
            foreach ($entry as $name => $value) {
                if (substr($name, 0, 5)=='data-') {
                    $data .=  ' ' . $name . '="' . htmlspecialchars($value) . '"';
                }
            }
          
            /*
              if(isset($entry['js'])) {
              $data .=  ' data-ig-anim="'.$entry['js'].'"';
              }
              if(isset($entry['trigger-selector'])) {
              $data .=  ' data-ig-trigger-selector="'.$entry['trigger-selector'].'"';
              }
              if(isset($entry['trigger-hook'])) {
              $data .=  ' data-ig-trigger-hook="'.$entry['trigger-hook'].'"';
              }
              if(isset($entry['animation-selector'])) {
              $data .=  ' data-ig-animation-selector="'.$entry['animation-selector'].'"';
              }
            */
        }
        return trim($data);
    }
}
