// Detect Closest Edge
function closestEdge(x, y, w, h) {
    var topEdgeDist = distMetric(x, y, w / 2, 0);
    var bottomEdgeDist = distMetric(x, y, w / 2, h);
    var leftEdgeDist = distMetric(x, y, 0, h / 2);
    var rightEdgeDist = distMetric(x, y, w, h / 2);
    var min = Math.min(topEdgeDist, bottomEdgeDist, leftEdgeDist, rightEdgeDist);
    switch (min) {
        case leftEdgeDist:
            return 'left';
        case rightEdgeDist:
            return 'right';
        case topEdgeDist:
            return 'top';
        case bottomEdgeDist:
            return 'bottom';
    }
}

function getDirectionKey(e, element) {
    var width = element.outerWidth();
    var height = element.outerHeight();
    var top = element.offset().top;
    var left = element.offset().left;

    var x = (e.pageX - left - (width / 2) * (width > height ? height / width : 1));
    var y = (e.pageY - top - (height / 2) * (height > width ? width / height : 1));

    var distanceIndex = Math.round(Math.atan2(y, x) / 1.57079633 + 5) % 4;

    switch (distanceIndex) {
        case 0:
            return 'top';
        case 1:
            return 'right';
        case 2:
            return 'bottom';
        case 3:
            return 'left';
    }
}

// Distance Formula
function distMetric(x, y, x2, y2) {
    var xDiff = x - x2;
    var yDiff = y - y2;
    return (xDiff * xDiff) + (yDiff * yDiff);
}
let edgeDetectionObserver = document.querySelectorAll('.edgeDetectionObserver');
edgeDetectionObserver?.forEach(function (el) {
    var container = el;
    var triggerHoverSelector = container.dataset.igTriggerHoverSelector || '.ce-textpic';
    var overlaySelector = container.dataset.igOverlaySelector || '.ce-bodytext';
    var onEnterFunctionName = container.dataset.igOnEnterFunctionName;
    var onLeaveFunctionName = container.dataset.igOnLeaveFunctionName;
    if (typeof window[onEnterFunctionName] !== "function") {
        console.log('edgeDetectionObserver: animation function not found: ' + onEnterFunctionName);
        return;
    }
    if (typeof window[onLeaveFunctionName] !== "function") {
        console.log('edgeDetectionObserver: animation function not found: ' + onLeaveFunctionName);
        return;
    }
    var hoverElement = container.querySelector(triggerHoverSelector);
    var overlay = hoverElement.querySelector(overlaySelector);

    hoverElement.addEventListener('mouseenter', () => {
        var x = e.pageX - hoverElement.getBoundingClientRect().left;
        var y = e.pageY - hoverElement.getBoundingClientRect().top;
        var edge = closestEdge(x, y, hoverElement.offsetWidth, hoverElement.offsetHeight);
        window[onEnterFunctionName](overlay, edge);
    });
    hoverElement.addEventListener('mouseleave', () => {
        var x = e.pageX - hoverElement.getBoundingClientRect().left;
        var y = e.pageY - hoverElement.getBoundingClientRect().top;
        var edge = closestEdge(x, y, hoverElement.offsetWidth, hoverElement.offsetHeight);
        console.log(onLeaveFunctionName);
        window[onLeaveFunctionName](overlay, edge);
    });
});