<?php

namespace Ig\IgAnimation\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ClassViewHelper extends AbstractViewHelper
{

    /**
     * Initialize arguments.
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('collection', 'string', 'Collection name', false, 'animations');
        $this->registerArgument('id', 'string', 'ID of Animation', false);
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render()
    {
        $yamlUtility=GeneralUtility::makeInstance(\Ig\IgAnimation\Utility\YamlUtility::class);

        if ($entry=$yamlUtility->getCollectionEntryById($this->arguments['collection'], $this->arguments['id'])) {
            return $entry['class'];
        }
        return '';
    }
}
