function progressRemoveClassPause(event) {
    var triggerElement = event.target.triggerElement();
    triggerElement?.classList.remove('pause');
}
function progressAnimeSeek(event) {
    var triggerElement = event.target.triggerElement();
    triggerElement.animation.seek(triggerElement.animation.duration * event.progress);
}
function animeFadeInLeft(targets, el) {
    return anime(
        {
            targets: targets,
            translateX: ['-110%', 0],
            elasticity: 0,
            easing: 'easeInOutCubic',
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeFadeInRight(targets, el) {
    return anime(
        {
            targets: targets,
            translateX: ['110%', 0],
            elasticity: 0,
            easing: 'easeInOutCubic',
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeFadeInUp(targets, el) {
    return anime(
        {
            targets: targets,
            easing: 'easeInOutCubic',
            translateY: ['30%', 0],
            opacity: [0, 1],
            elasticity: 0,
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeFadeIn(targets, el) {
    return anime(
        {
            targets: targets,
            easing: 'linear',
            opacity: [0, 1],
            elasticity: 0,
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeParallaxScrollingDownUp(targets, el) {
    return anime(
        {
            targets: targets,
            translateY: ['+20%', '-20%'],
            elasticity: 0,
            easing: 'linear',
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeParallaxScrollingUpDown(targets, el) {
    return anime(
        {
            targets: targets,
            translateY: ['-20%', '+20%'],
            elasticity: 0,
            easing: 'linear',
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
function animeRotate360(targets, el) {
    return anime(
        {
            targets: targets,
            rotate: [0, 360],
            elasticity: 0,
            easing: 'linear',
            delay: 0,
            duration: 2000,
            autoplay: false
        }
    );
}
let scrollMagicObserver = document.querySelectorAll('.scrollMagicObserver');
scrollMagicObserver?.forEach(function (el) {
    let animationSelector = el.dataset.igAnimationSelector;
    let triggerSelector = el.dataset.igTriggerSelector;
    let triggerHook = el.dataset.igTriggerHook;
    let animationTarget = el;
    if (animationSelector) {
        animationTarget = Array.from(el.querySelectorAll(animationSelector));
    }
    let animationFunction = false;
    let animationFunctionName = el.dataset.igAnimationFunction;
    if (animationFunctionName != undefined) {
        if (typeof window[animationFunctionName] === "function") {
            animationFunction = window[animationFunctionName];
        } else {
            console.log('scrollMagicObserver: animation function not found: ' + animationFunctionName);
            return;
        }
    }
    let progressFunction = false;
    let progressFunctionName = el.dataset.igProgressFunction;
    if (progressFunctionName != undefined) {
        if (typeof window[progressFunctionName] !== "function") {
            console.log('scrollMagicObserver: progressFunction not found: ' + progressFunctionName);
            return;
        } else {
            progressFunction = window[progressFunctionName];
        }
    }
    let controller = new ScrollMagic.Controller();
    if (triggerSelector) {
        var triggerElements = el.querySelectorAll(triggerSelector);
        console.log(triggerElements);
        triggerElements.forEach(function (triggerElement) {
            if (animationFunction) {
                this.animation = animationFunction(this, el);
            }

            var scene = new ScrollMagic.Scene({
                triggerElement: el,
                duration: elThisJQuery.data('ig-trigger-duration'),
                triggerHook: triggerHook ? triggerHook : "onEnter"
            })
                .addTo(controller).
                on("progress", progressFunction);
        });
    } else {

        if (animationFunction) {
            el.animation = animationFunction(animationTarget, el);
        }
        var scene = new ScrollMagic.Scene({
            triggerElement: el,
            duration: el.dataset.igTriggerDuration,
            triggerHook: triggerHook ? triggerHook : "onEnter"
        }).addTo(controller).on("progress", progressFunction);
    }
});