<?php
namespace Ig\IgAnimation\Utility;

use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Configuration\Loader\YamlFileLoader;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;

class YamlUtility implements SingletonInterface
{

    protected $yaml = null;

    protected $observers = [];

    public function __construct()
    {
        //$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        $configurationManager = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Configuration\ConfigurationManager::class);
        $typoscript = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $this->settings = $typoscript['plugin.']['tx_iganimation.']['settings.'] ?? [];
        $currentYamlFile = $this->settings['yaml'] ?? '';
        if ($currentYamlFile) {
            $loader = GeneralUtility::makeInstance(YamlFileLoader::class);
            $this->yaml = $loader->load($currentYamlFile);
            if ($this->yaml !== null && isset($this->yaml['observers'])) {
                foreach ($this->yaml['observers'] as $observer) {
                    if ($observer['id'] ?? false) {
                        $this->observers[$observer['id']] = $observer;
                    }
                }
            }
        }
    }

    public function getCollection($collectionName)
    {
        if (isset($this->yaml[$collectionName])) {
            return $this->yaml[$collectionName];
        }
        return false;
    }

    public function getCollectionEntryById($collectionName, $id)
    {
        if ($collection = $this->getCollection($collectionName)) {
            foreach ($collection as $entry) {
                if (isset($entry['id']) && $entry['id'] == $id) {
                    if (isset($entry['observer'])) {
                        if (isset($this->observers[$entry['observer']])) {
                            $observer = $this->observers[$entry['observer']];
                            if (isset($observer['class'])) {
                                $entry['class'] = $observer['class'] . (isset($entry['class']) ? ' ' . $entry['class'] : '') ;
                            }
                            // Default Werte von Observer kopieren
                            foreach ($observer as $name => $value) {
                                if (substr($name, 0, 5)=='data-' && !isset($entry[$name])) {
                                    $entry[$name]=$observer[$name];
                                }
                            }
                        } else {
                            // Observer Missing
                        }
                    }
                    return $entry;
                }
            }
        }
        return false;
    }
}
