function hoverSwipeInEnter( overlay, edge ) {
    var $overlay = $(overlay);
    var animeOptions = {
        targets: overlay,
        easing: 'linear',
        duration: 250
    };
    switch(edge) {
        case 'left':
            // overlay from the left
            $overlay.css({
                'top' : '0%',
                'left' : '-100%'
            });
            animeOptions.left = '0%';
            anime(animeOptions);
            break;
        case 'right':
            // overlay from the right
            $overlay.css({
                'top' : '0%',
                'left' : '100%'
            });
            animeOptions.left = '0%';
            anime(animeOptions);
            break;
        case 'top':
            // overlay from the right
            $overlay.css({
                'top' : '-100%',
                'left' : '0%'
            });
            animeOptions.top = '0%';
            anime(animeOptions);
            break;
        case 'bottom':
            // overlay from the right
            $overlay.css({
                'top' : '100%',
                'left' : '0%'
            });
            animeOptions.top = '0%';
            anime(animeOptions);
            break;
    }
}

function hoverSwipeInLeave( overlay, edge ) {
    var $overlay = $(overlay);
    var animeOptions = {
        targets: overlay,
        easing: 'linear',
        duration: 250
    };

    switch(edge) {
        case 'left':
            animeOptions.left = '-100%';
            anime(animeOptions);
            break;
        case 'right':
            animeOptions.left = '100%';
            anime(animeOptions);
            break;
        case 'top':
            animeOptions.top = '-100%';
            anime(animeOptions);
            break;
        case 'bottom':
            animeOptions.top = '100%';
            anime(animeOptions);
            break;
    }
}