function hover3dEnter( overlay, edge ) {
    var $overlay = $(overlay);
    var animeOptions = {
        targets: overlay,
        easing: 'linear',
        duration: 250
    };
    switch(edge) {
        case 'left':
            // overlay from the left
            $overlay.css({
                'top' : '0%',
                'left' : '0%',
                'transform': 'rotateY(108deg)',
                'transform-origin': 'left'
            });
            animeOptions.rotateY = '0deg';
            anime(animeOptions);
            break;
        case 'right':
            // overlay from the right
            $overlay.css({
                'top' : '0%',
                'left' : '0%',
                'transform': 'rotateY(-108deg)',
                'transform-origin': 'right'
            });
            animeOptions.rotateY = '0deg';
            anime(animeOptions);
            break;
        case 'top':
            // overlay from the right
            $overlay.css({
                'top' : '0%',
                'left' : '0%',
                'transform': 'rotateX(-104deg)',
                'transform-origin': 'top'
            });
            animeOptions.rotateX = '0deg';
            anime(animeOptions);
            break;
        case 'bottom':
            // overlay from the right
            $overlay.css({
                'top' : '0%',
                'left' : '0%',
                'transform': 'rotateX(104deg)',
                'transform-origin': 'bottom'
            });
            animeOptions.rotateX = '0deg';
            anime(animeOptions);
            break;
    }

}

function hover3dLeave( overlay, edge ) {
    var $overlay = $(overlay);
    var animeOptions = {
        targets: overlay,
        easing: 'linear',
        duration: 250
    };

    switch(edge) {
        case 'left':
            $overlay.css({
                'transform-origin': 'left'
            });
            animeOptions.rotateY = '108deg';
            anime(animeOptions);
            break;
        case 'right':
            $overlay.css({
                'transform-origin': 'right'
            });
            animeOptions.rotateY = '-108deg';
            anime(animeOptions);
            break;
        case 'top':
            $overlay.css({
                'transform-origin': 'top'
            });
            animeOptions.rotateX = '-104deg';
            anime(animeOptions);
            break;
        case 'bottom':
            $overlay.css({
                'transform-origin': 'bottom'
            });
            animeOptions.rotateX = '104deg';
            anime(animeOptions);
            break;
    }

}