
// Hilfs Funktion fuer Threshold
function buildThresholdList(startPoint, numSteps) {
    var thresholds = [];

    for (var i = startPoint; i <= numSteps; i++) {
        var ratio = i / numSteps;
        thresholds.push(ratio);
    }

    return thresholds;
}

var callback = function (entries, observer) {
    entries.forEach(function (entry) {
        var isAbove = entry.boundingClientRect.y < entry.rootBounds.y;
        if (entry.isIntersecting) {
            entry.target.classList.remove('pause');
            let progressFunction = entry.target?.dataset.igProgressFunction;
            if (progressFunction) {
                window[progressFunction](entry.target);
            }
        }
    });
};

var options = {
    root: null,
    rootMargin: '50px 0px 0px 0px',
    threshold: [0.0]
};

var observer = new IntersectionObserver(callback, options);
let intersectionObserver = document.querySelectorAll('.intersectionObserver');
intersectionObserver?.forEach(function (el) {
    observer.observe(el);
});
