<?php

declare(strict_types=1);

namespace Internetgalerie\IgApiLogin\Dispatcher;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use SourceBroker\T3api\Service\SerializerService;
use SourceBroker\T3api\Dispatcher\AbstractDispatcher;
use TYPO3\CMS\Core\Http\Response;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\Authentication\FrontendUserAuthentication;
use TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory;

use Psr\EventDispatcher\EventDispatcherInterface;
use TYPO3\CMS\Core\RateLimiter\RateLimiterFactory;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Authentication\LoginType;

use Psr\Http\Server\RequestHandlerInterface;
use TYPO3\CMS\Frontend\Middleware\FrontendUserAuthenticator;

class Bootstrap extends FrontendUserAuthenticator
{
    protected ?int $storagePid = null;
    
    public function __construct(
        protected readonly Context $context,
        protected readonly RateLimiterFactory $rateLimiterFactory,
        protected readonly EventDispatcherInterface $eventDispatcher,
        protected readonly SerializerService $serializerService,
    ) {}
     
    /**
     * @throws \Throwable
     */
    public function processLogin(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $this->response = new Response('php://temp', 200, ['Content-Type' => 'application/ld+json']);
        //$request = $this->httpFoundationFactory->createRequest($inputRequest);
        $parsedBody = $request->getParsedBody();
        $username = $request->getQueryParams()['username'] ?? $parsedBody['username'] ?? null;
        $password = $request->getQueryParams()['password'] ?? $parsedBody['password'] ?? null;
        $action = $action;
        $success = false;

        /*
        $username = 'da';
            $password = 'da';
        */

        // set data for typo3 login
        $parsedBody['user'] = $username;
        $parsedBody['pass'] = $password;
        $parsedBody['logintype'] = LoginType::LOGIN->value ?? 'login';
        $request = $request->withParsedBody($parsedBody);

        $frontendUser = GeneralUtility::makeInstance(FrontendUserAuthentication::class);
        $GLOBALS['TYPO3_CONF_VARS']['SVCONF']['auth']['setup']['FE' . '_fetchUserIfNoSession'] = true;
        //$frontendUser->checkPid = false;
        $frontendUser->checkPid_value = $this->storagePid;
        $frontendUser->start($request);
        $frontendUser->fetchGroupData($request);
        $this->context->setAspect('frontend.user', $frontendUser->createUserAspect());
        $request = $request->withAttribute('frontend.user', $frontendUser);

        if ($this->context->getAspect('frontend.user')->isLoggedIn() && $rateLimiter) {
            $rateLimiter->reset();
            $this->eventDispatcher->dispatch(new AfterUserLoggedInEvent($frontendUser, $request));
        }

        //$response = $handler->handle($request);
       // Store session data for fe_users if it still exists
        if ($frontendUser instanceof FrontendUserAuthentication) {
            $success = ($frontendUser->user !== null);
            $frontendUser->storeSessionData();
            $this->response = $frontendUser->appendCookieToResponse($this->response, $request->getAttribute('normalizedParams'));
            // Collect garbage in Frontend requests, which aren't fully cacheable (e.g. with cookies)
            if ($this->response->hasHeader('Set-Cookie')) {
                $this->sessionGarbageCollection();
            }
        }

        $data = [
            'success' => $success,
            //'session' => 'dgfsCFNJj4t0jfcewsqa0t2ugJCOi9jrgwegb90234w',
            'mode' => 'cookie',
            //'input' => $parsedBody,
            'user' => [
                'uid' => $frontendUser->user['uid']  ?? null,
                'username' => $frontendUser->user['username'] ?? null
            ],
        ];
        $output = $this->serializerService->serialize($data);
        $this->response->getBody()->write($output);
        return $this->response;
        /*
        if ($username !== null && $username !== '' && $password !== null)  {
            // Frontend user authentication
            $feUser = $frontendUser->getRawUserByName($username);
            if ($feUser) {
                $saltFactory = GeneralUtility::makeInstance(PasswordHashFactory::class);
                try {
                    // Get the password hash instance used for this user
                    $hashInstance = $saltFactory->get($feUser['password'], 'FE');
                } catch (InvalidPasswordHashException $exception) {
                    // Handle invalid password hash exception (if any)
                    $this->response->getBody()->write(json_encode(['error' => 'Invalid password hash']));
                    return $this->response->withStatus(500);
                }
                // Check the password
                $isValidPassword = $hashInstance->checkPassword($password, $feUser['password']);
                if ($isValidPassword) {
                    $data = [
                        'success' => true,
                        'session' => 'dgfsCFNJj4t0jfcewsqa0t2ugJCOi9jrgwegb90234w',
                        'data' => $parsedBody,
                        'used' => [
                            'username' => $username,
                            'password' => $password,
                            'action' => $action,
                        ],
                    ];
                    var_dump($username, $feUser);exit(0);
                }
            }
        
        }
        $output = $this->serializerService->serialize($data);
        $this->response->getBody()->write($output);
        return $this->response;
        */
    }

    /**
     * @throws \Throwable
     */
    public function processLogout(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $this->response = new Response('php://temp', 200, ['Content-Type' => 'application/ld+json']);
        $data = ['success' => true];
        $parsedBody = $request->getParsedBody();
        $parsedBody['logintype'] = LoginType::LOGOUT->value ?? 'logout';
        $request = $request->withParsedBody($parsedBody);
        $frontendUser = GeneralUtility::makeInstance(FrontendUserAuthentication::class);
        $frontendUser->start($request);

        $output = $this->serializerService->serialize($data);
        $this->response->getBody()->write($output);
        return $this->response;
    }

}