<?php

declare(strict_types=1);

namespace Internetgalerie\IgApiLogin\EventListener;

use GoldSpecDigital\ObjectOrientedOAS\Objects\Components;
use GoldSpecDigital\ObjectOrientedOAS\Objects\SecurityScheme;
use SourceBroker\T3api\Event\AfterProcessComponentsEvent;

final class AfterProcessComponentsEventListener
{
    public function __invoke(AfterProcessComponentsEvent $event): void
    {
        $components = $event->getComponents();

        $bearerAuth = SecurityScheme::create('BearerAuth')
            ->type(SecurityScheme::TYPE_HTTP)
            ->scheme('bearer')
            ->bearerFormat('JWT');
        // Add the security scheme to the components
        $components = $components->securitySchemes($bearerAuth);
        $event->setComponents($components);
    }
}

