<?php

declare(strict_types=1);

namespace Internetgalerie\IgApiLogin\EventListener;

use GoldSpecDigital\ObjectOrientedOAS\Objects\SecurityRequirement;
use SourceBroker\T3api\Event\AfterProcessOpenApiEvent;

final class AfterProcessOpenApiEventListener
{
    public function __invoke(AfterProcessOpenApiEvent $event): void
    {
        $openApi = $event->getOpenApi();
        $security = SecurityRequirement::create()->securityScheme('BearerAuth');
        $openApi = $openApi->security($security);
        $event->setOpenApi($openApi);
    }
}

