<?php

declare(strict_types=1);

namespace Internetgalerie\IgApiLogin\Middleware;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;
use TYPO3\CMS\Core\Authentication\LoginType;
use SourceBroker\T3api\Routing\Enhancer\ResourceEnhancer;
use TYPO3\CMS\Core\Http\ServerRequest;
use TYPO3\CMS\Core\Session\UserSessionManager;



use TYPO3\CMS\Frontend\Authentication\FrontendUserAuthentication;

class IgApiJwtFrontendUserAuthenticatorSession implements MiddlewareInterface
{
    public $loginType = 'FE';

    
    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $authHeader = $request->getHeaderLine('Authorization');
        if (str_starts_with($authHeader, 'Bearer ')) {
            $jwt = substr($authHeader, 7);

            $cookieName = $this->getFrontendCookieName();
            $request = $request->withCookieParams(array_merge(
                $request->getCookieParams() ?? [],
                [$cookieName => $jwt]
            ));
            $this->userSessionManager = UserSessionManager::create($this->loginType);
            $this->userSession = $this->userSessionManager->createFromRequestOrAnonymous($request, $cookieName);
            return $handler->handle($request);
        }
        return $handler->handle($request);
    }

    protected function getFrontendCookieName(): string
    {
        return FrontendUserAuthentication::getCookieName();
    }

}
