<?php

declare(strict_types=1);

namespace Internetgalerie\IgApiLogin\Middleware;

use Internetgalerie\IgApiLogin\Dispatcher\Bootstrap;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;
use SourceBroker\T3api\Routing\Enhancer\ResourceEnhancer;
use TYPO3\CMS\Core\Http\ServerRequest;

class IgApiRequestResolver implements MiddlewareInterface
{
    public const PARAMETER_LOGIN = 'frontend-user/login';
    public const PARAMETER_LOGOUT = 'frontend-user/logout';
    protected Bootstrap $bootstrap;

    
    public function __construct(Bootstrap $bootstrap)
    {
        $this->bootstrap = $bootstrap;
    }


    
    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        if ($request instanceof ServerRequest) {
            $queryParams = $request->getQueryParams() ?? [];
            $value =  $queryParams[ResourceEnhancer::PARAMETER_NAME] ?? null;
            if ($value === self::PARAMETER_LOGIN) {
                return $this->bootstrap->processLogin($this->cleanupRequest($request), $handler);
            }
            if ($value === self::PARAMETER_LOGOUT) {
                return $this->bootstrap->processLogout($this->cleanupRequest($request), $handler);
            }
        }
        return $handler->handle($request);
    }

    private function cleanupRequest(ServerRequestInterface $request): ServerRequestInterface
    {
        $cleanedQueryParams = $request->getQueryParams();
        unset($cleanedQueryParams[ResourceEnhancer::PARAMETER_NAME]);

        return $request->withQueryParams($cleanedQueryParams);
    }

}
