/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var __decorate = function (e, t, o, r) {
  var n, i = arguments.length,
    s = i < 3 ? t : null === r ? r = Object.getOwnPropertyDescriptor(t, o) : r;
  if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) s = Reflect.decorate(e, t, o, r);
  else
    for (var a = e.length - 1; a >= 0; a--)(n = e[a]) && (s = (i < 3 ? n(s) : i > 3 ? n(t, o, s) : n(t, o)) || s);
  return i > 3 && s && Object.defineProperty(t, o, s), s
};

import {html, LitElement, nothing} from "lit";
import {customElement, property, query} from "lit/decorators.js";
import {until} from "lit/directives/until.js";
import {lll} from "@typo3/core/lit-helper.js";
import {CategoryTree} from "@internetgalerie/igbackendhelpers/tree/category-tree.js";
import AjaxRequest from "@typo3/core/ajax/ajax-request.js";
import Persistent from "@typo3/backend/storage/persistent.js";
import {ModuleUtility} from "@typo3/backend/module.js";
//import * as d3selection from "d3-selection";
//import {Toolbar} from "@typo3/backend/svg-tree.js";
//import {Tree} from "@typo3/backend/tree/tree.js"
import {TreeToolbar} from "@typo3/backend/tree/tree-toolbar.js";
import {ModuleStateStorage} from "@typo3/backend/storage/module-state-storage.js";

export const navigationComponentName = "typo3-backend-navigation-component-categorytree";
let EditableCategoryTree = class extends CategoryTree {
  selectFirstNode() {
    this.selectNode(this.nodes[0], !0), this.focusNode(this.nodes[0])
  }
  sendChangeCommand(e) {
    let t = 0;
    e.target && (t = e.target.identifier, "after" === e.position && (t = -t)), this.requestTreeUpdate("").then((e => {
      e && e.hasErrors ? (this.errorNotification(e.messages, !1), this.nodesContainer.selectAll(".node").remove(), this.updateVisibleNodes(), this.nodesRemovePlaceholder()) : this.refreshOrFilterTree()
    }))
  }
  focusNode(e) {
    this.nodeIsEdit || super.focusNode(e)
  }
  nodesUpdate(e) {
    return super.nodesUpdate.call(this, e)
  }
  updateNodeBgClass(e) {
    return super.updateNodeBgClass.call(this, e)
  }
/*
    removeEditedText() {
    const e = d3selection.selectAll(".node-edit");
    if (e.size()) try {
      e.remove(), this.nodeIsEdit = !1
      } catch (e) { }
  }
      */
  requestTreeUpdate(e, t = null) {
    return this.nodesAddPlaceholder(t), new AjaxRequest(top.TYPO3.settings.ajaxUrls.record_process).post(e, {
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "X-Requested-With": "XMLHttpRequest"
      }
    }).then((e => e.resolve())).catch((e => {
      this.errorNotification(e, !0)
    }))
  }
};
EditableCategoryTree = __decorate([customElement("typo3-backend-navigation-component-categorytree-tree")], EditableCategoryTree);
export {
  EditableCategoryTree
};
let CategoryTreeNavigationComponent = class extends LitElement {
  constructor() {
      super(...arguments),this.mountPointPath = null, this.configuration = null, this.refresh = () => {
      this.tree.refreshOrFilterTree()
    }, this.setMountPoint = e => {
      this.setTemporaryMountPoint(e.detail.pageId)
    }, this.selectFirstNode = () => {
      this.tree.selectFirstNode()
    }, this.toggleExpandState = e => {
      const t = e.detail.node;
      t && Persistent.set("BackendComponents.States.Categorytree." + top.TYPO3.settings.extensionName + "." + top.TYPO3.settings.tableType + ".stateHash." + t.stateIdentifier, t.expanded ? "1" : "0")
    }, this.loadContent = e => {
      const t = e.detail.node;
      if (!t?.checked) return;
      if (ModuleStateStorage.updateWithTreeIdentifier(top.TYPO3.settings.extensionName.toLowerCase(), t.identifier, t.stateIdentifier), !1 === e.detail.propagate) return;
      const o = top.TYPO3.ModuleMenu.App;
      let r = ModuleUtility.getFromName(o.getCurrentModule()).link;
      r += r.includes("?") ? "&" : "?", top.TYPO3.Backend.ContentContainer.setUrl(r + "id=" + t.pid + "&entryId=" + t.identifier)
    }, this.selectActiveNode = e => {
      const t = ModuleStateStorage.current(top.TYPO3.settings.extensionName.toLowerCase()).selection.split("_")[0],
        o = e.detail.nodes;
      e.detail.nodes = o.map((e => (e.stateIdentifier === t && (e.checked = !0), e)))
    }


  }
  connectedCallback() {
    super.connectedCallback(), document.addEventListener("typo3:categorytree:refresh", this.refresh), document.addEventListener("typo3:categorytree:mountPoint", this.setMountPoint), document.addEventListener("typo3:categorytree:selectFirstNode", this.selectFirstNode)
  }
  disconnectedCallback() {
    document.removeEventListener("typo3:categorytree:refresh", this.refresh), document.removeEventListener("typo3:categorytree:mountPoint", this.setMountPoint), document.removeEventListener("typo3:categorytree:selectFirstNode", this.selectFirstNode), super.disconnectedCallback()
  }
  createRenderRoot() {
    return this
  }
  render() {
    return html`
      <div id="typo3-categorytree" class="tree">
        ${until(this.renderTree())}
      </div>
    `
  }
  getConfiguration() {
    if (null !== this.configuration) return Promise.resolve(this.configuration);
    let tableType = top.TYPO3.settings.tableType;
    if (!tableType) {
	tableType = 'category';
    }
      
    const moduleMenuApp = top.TYPO3.ModuleMenu.App;
    const extensionName = moduleMenuApp.getCurrentModule().split('_')[0];
    const extensionNameLowerCase = extensionName.toLowerCase();


      const e = top.TYPO3.settings.ajaxUrls[extensionNameLowerCase + '_' + tableType + '_tree_configuration'];
    return new AjaxRequest(e).get().then((async e => {
      const t = await e.resolve("json");
      return this.configuration = t, this.mountPointPath = t.temporaryMountPoint || null, t
    }))
  }
  renderTree() {
    return this.getConfiguration().then((e => html`
            <typo3-backend-navigation-component-categorytree-toolbar id="typo3-categorytree-toolbar" .tree="${this.tree}"></typo3-backend-navigation-component-categorytree-toolbar>
            <div id="typo3-categorytree-treeContainer" class="navigation-tree-container">
              ${this.renderMountPoint()}
              <typo3-backend-navigation-component-categorytree-tree id="typo3-categorytree-tree" class="tree-wrapper" .setup=${e} @tree:initialized=${() => { this.toolbar.tree = this.tree, this.tree.addEventListener("typo3:tree:expand-toggle", this.toggleExpandState), this.tree.addEventListener("typo3:tree:node-selected", this.loadContent), this.tree.addEventListener("typo3:tree:nodes-prepared", this.selectActiveNode) }}></typo3-backend-navigation-component-categorytree-tree>
            </div>
        `))
  }
  unsetTemporaryMountPoint() {
    this.mountPointPath = null, Persistent.unset("categoryTree_temporaryMountPoint").then((() => {
      this.tree.refreshTree()
    }))
  }
  renderMountPoint() {
    return null === this.mountPointPath ? nothing : html`
      <div class="node-mount-point">
        <div class="node-mount-point__icon"><typo3-backend-icon identifier="actions-info-circle" size="small"></typo3-backend-icon></div>
        <div class="node-mount-point__text">${this.mountPointPath}</div>
        <div class="node-mount-point__icon mountpoint-close" @click="${()=>this.unsetTemporaryMountPoint()}" title="${lll("labels.temporaryDBmount")}">
          <typo3-backend-icon identifier="actions-close" size="small"></typo3-backend-icon>
        </div>
      </div>
    `
  }
  setTemporaryMountPoint(e) {
    new AjaxRequest(this.configuration.setTemporaryMountPointUrl).post("pid=" + e, {
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "X-Requested-With": "XMLHttpRequest"
      }
    }).then((e => e.resolve())).then((e => {
      e && e.hasErrors ? (this.tree.errorNotification(e.message, !0), this.tree.updateVisibleNodes()) : (this.mountPointPath = e.mountPointPath, this.tree.refreshOrFilterTree())
    })).catch((e => {
      this.tree.errorNotification(e, !0)
    }))
  }
};
__decorate([property({
  type: String
})], CategoryTreeNavigationComponent.prototype, "mountPointPath", void 0), __decorate([query(".tree-wrapper")], CategoryTreeNavigationComponent.prototype, "tree", void 0), __decorate([query("typo3-backend-navigation-component-categorytree-toolbar")], CategoryTreeNavigationComponent.prototype, "toolbar", void 0), CategoryTreeNavigationComponent = __decorate([customElement("typo3-backend-navigation-component-categorytree")], CategoryTreeNavigationComponent);
export {
  CategoryTreeNavigationComponent
};
let CategoryTreeToolbar = class extends TreeToolbar {
  constructor() {
    super(...arguments), this.tree = null
  }
  updated(e) { }
  render() {
    return html`
      <div class="tree-toolbar">
        <div class="tree-toolbar__menu">
          <div class="tree-toolbar__search">
              <label for="toolbarSearch" class="visually-hidden">
                ${lll("labels.label.searchString")}
              </label>
              <input type="search" id="toolbarSearch" class="form-control form-control-sm search-input" placeholder="${lll("tree.searchTermInfo")}">
          </div>
        </div>
        <div class="tree-toolbar__submenu">
          ${this.tree?.settings?.doktypes?.length?this.tree.settings.doktypes.map((e=>html`
                <div
                  class="tree-toolbar__menuitem tree-toolbar__drag-node"
                  draggable="true"
                  data-tree-icon="${e.icon}"
                  data-node-type="${e.nodeType}"
                  @dragstart="${t=>{this.handleDragStart(t,e)}}"
                >
                  <typo3-backend-icon identifier="${e.icon}" size="small"></typo3-backend-icon>
                </div>
              `)):""}
          <button
            type="button"
            class="tree-toolbar__menuitem dropdown-toggle dropdown-toggle-no-chevron float-end"
            data-bs-toggle="dropdown"
            aria-expanded="false"
          >
            <typo3-backend-icon identifier="actions-menu-alternative" size="small"></typo3-backend-icon>
          </button>
          <ul class="dropdown-menu dropdown-menu-end">
            <li>
              <button class="dropdown-item" @click="${()=>this.refreshTree()}">
                <span class="dropdown-item-columns">
                  <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden="true">
                    <typo3-backend-icon identifier="actions-refresh" size="small"></typo3-backend-icon>
                  </span>
                  <span class="dropdown-item-column dropdown-item-column-title">
                    ${lll("labels.refresh")}
                  </span>
                </span>
              </button>
            </li>
            <li>
              <button class="dropdown-item" @click="${e=>this.collapseAll(e)}">
                <span class="dropdown-item-columns">
                  <span class="dropdown-item-column dropdown-item-column-icon" aria-hidden="true">
                    <typo3-backend-icon identifier="apps-pagetree-category-collapse-all" size="small"></typo3-backend-icon>
                  </span>
                  <span class="dropdown-item-column dropdown-item-column-title">
                    ${lll("labels.collapse")}
                  </span>
                </span>
              </button>
            </li>
          </ul>
        </div>
      </div>
    `
  }
};
__decorate([property({
  type: EditableCategoryTree
})], CategoryTreeToolbar.prototype, "tree", void 0), CategoryTreeToolbar = __decorate([customElement("typo3-backend-navigation-component-categorytree-toolbar")], CategoryTreeToolbar);