<?php
declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Controller;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\Configuration\BackendUserConfiguration;
use TYPO3\CMS\Backend\Template\ModuleTemplateFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;


abstract class AbstractBackendTableListController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    protected string $tableName = '';
    protected string $entryIdSearchAttribute = 'parent';
    protected string $entryIdArgumentName = 'entryId';
    protected $entryId = 0;
    protected $pageUid = 0;
    protected array $search = [];
    protected string $pageUidArgumentName = 'id';
    protected string $searchArgumentName = 'search';

    public function __construct(
                protected readonly ModuleTemplateFactory $moduleTemplateFactory
    ) {}

    public function initializeAction(): void
    {
        $this->entryId = $this->request->hasArgument($this->entryIdArgumentName) ? $this->request->getArgument($this->entryIdArgumentName) : GeneralUtility::_GET($this->entryIdArgumentName);
        $this->pageUid = $this->request->hasArgument($this->pageUidArgumentName) ? $this->request->getArgument($this->pageUidArgumentName) : GeneralUtility::_GET($this->pageUidArgumentName);
        $this->search = $this->request->hasArgument($this->searchArgumentName) ? $this->request->getArgument($this->searchArgumentName) : [];
    }

    /**
     * Action index
     *
     * @return void
     */
    public function indexAction(): ResponseInterface
    {
        $moduleTemplate = $this->moduleTemplateFactory->create($this->request);
        if(!$this->tableName) {
            die('$this->tableName is not defined in ' . get_class($this));
        }
        if(!isset($GLOBALS['TCA'][$this->tableName])) {
            die('$this->tableName has value "' . $this->tableName . '", but is not found in TCA. In class ' . get_class($this));
        }
        /*if(!$this->entryIdSearchAttribute) {
            die('$this->entryIdSearchAttribute is not defined in ' . get_class($this));
        }*/
        //TODO: HERE var_dump($this->request->getArguments());


        $where = [];
        if($this->entryId > 0) {
            $where = [$this->entryIdSearchAttribute => $this->entryId];
        }
        $this->search = array_merge($this->search, $where);

        $this->view->assign('tableName', $this->tableName);
        $this->view->assign('entryId', $this->entryId);
        $this->view->assign('searchArgumentName', $this->searchArgumentName);
        $this->view->assign('entryIdArgumentName', $this->entryIdArgumentName);
        $this->view->assign('entryIdSearchAttribute', $this->entryIdSearchAttribute);
        $this->view->assign('pageUid', $this->pageUid);

        $this->view->assign('where', $where);
        $this->view->assign('search', $this->search);
        $returnUrlParameters = [
            $this->searchArgumentName => $this->search,
        ];
        if($this->entryId > 0) {
            $returnUrlParameters[$this->entryIdArgumentName] = $this->entryId;
        }
        $this->view->assign('returnUrlParameters', $returnUrlParameters);

        // Ausgewählte Kategorie im TCA bei anlegen setzen (Bei Frame tableTree und tableList)
        if ($this->entryId) {
            $defVals = [
                $this->tableName => [
                    $this->entryIdSearchAttribute =>  $this->entryId
                ],
            ];
        } else {
            $defVals = [];
        }
        $this->view->assign('defVals', $defVals);

        $moduleTemplate->setContent($this->view->render());
        return $this->htmlResponse($moduleTemplate->renderContent());
    }

}
