<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Utility;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Utilities to manage main modules of an extension
 */
class ExtensionUtility
{
    /**
     * Registers an Extbase main module to the backend interface.
     * FOR USE IN ext_tables.php FILES
     *
     * @param  string $mainModuleName      The main module key. So $main would be an index in the $TBE_MODULES array.
     * @param  string $position            This can be used to set the position of the $sub module within the list of existing submodules for the main module. $position has this syntax: [cmd]:[submodule-key]. cmd can be "after", "before" or "top" (or blank which is default). If "after"/"before" then submodule will be inserted after/before the existing submodule with [submodule-key] if found. If not found, the bottom of list. If "top" the module is inserted in the top of the submodule list.
     * @param  array  $moduleConfiguration The configuration options of the module (icon, locallang.xlf file)
     *
     * @throws \InvalidArgumentException
     */
    public static function registerMainModule(string $mainModuleName, string $position = '', array $moduleConfiguration = []): void
    {
        if (! isset($GLOBALS['TBE_MODULES'][$mainModuleName])) {
            [$place, $mainModuleRef] = array_pad(GeneralUtility::trimExplode(':', $position, true), 2, null);
            // everything not defined, is at bottom
            $temp_TBE_MODULES = [];
            if ($place === 'top') {
                $temp_TBE_MODULES[$mainModuleName] = '';
            }
            foreach ($GLOBALS['TBE_MODULES'] as $key => $val) {
                if ($key === $mainModuleRef) {
                    if ($place === 'before') {
                        $temp_TBE_MODULES[$mainModuleName] = '';
                    }
                    $temp_TBE_MODULES[$key] = $val;
                    if ($place === 'after') {
                        $temp_TBE_MODULES[$mainModuleName] = '';
                    }
                } else {
                    $temp_TBE_MODULES[$key] = $val;
                }
            }

            $GLOBALS['TBE_MODULES'] = $temp_TBE_MODULES;
        }
        \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addModule($mainModuleName, '', '', null, $moduleConfiguration);

        // Fast solution to create a shy navigation module
        if (! empty($moduleConfiguration['routeName'])) {
            $moduleConfiguration['shy'] = true;
            $moduleConfiguration['access'] = '';
            $moduleConfiguration['name'] = $moduleConfiguration['routeName'];
            \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addModule($moduleConfiguration['routeName'], '', '', null, $moduleConfiguration);
        }
        //self::registerModule($extensionName, $mainModuleName, '', '', [], $moduleConfiguration);
    }
}
