<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Utility;

/**
 * Utilities to manage main modules of an extension
 */
class BackendAjaxRoutesUtility
{
    /**
     * Returns the needed ajax routes for a category tree for an extension
     * @param  [type] $extensionName                [description]
     * @param  [type] $controllerName               [description]
     * @return [type]                 [description]
     */
    public static function getAjaxRoutesForTreeController($extensionName, $controllerName, $type = 'category')
    {
        $extensionNameLowerCase = strtolower((string) $extensionName);

        return [
            // Get data for category tree
            $extensionNameLowerCase . '_' . $type . '_tree_data' => [
                'path' => '/' . $extensionNameLowerCase . '/' . $type . '/tree/fetchData',
                'target' => $controllerName . '::fetchDataAction',
            ],

            // Get data for category tree
            $extensionNameLowerCase . '_' . $type . '_tree_filter' => [
                'path' => '/' . $extensionNameLowerCase . '/' . $type . '/tree/filterData',
                'target' => $controllerName . '::filterDataAction',
            ],

            // Get category tree configuration
            $extensionNameLowerCase . '_' . $type . '_tree_configuration' => [
                'path' => '/' . $extensionNameLowerCase . '/' . $type . '/tree/fetchConfiguration',
                'target' => $controllerName . '::fetchConfigurationAction',
            ],

            // Get page tree configuration for element browser and link handler
            $extensionNameLowerCase . '_' . $type . '_tree_browser_configuration' => [
                'path' => '/' . $extensionNameLowerCase . '/browser/' . $type . '/tree/fetchConfiguration',
                'target' => $controllerName . '::fetchReadOnlyConfigurationAction',
            ],

            // Set temporary mount point
            $extensionNameLowerCase . '_' . $type . '_tree_set_temporary_mount_point' => [
                'path' => '/' . $extensionNameLowerCase . '/' . $type . '/tree/setTemporaryMountPoint',
                'target' => $controllerName . '::setTemporaryMountPointAction',
            ],
        ];
    }
}
