/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
var __createBinding =
        (this && this.__createBinding) ||
        (Object.create
            ? function (e, t, o, i) {
                  void 0 === i && (i = o),
                      Object.defineProperty(e, i, {
                          enumerable: !0,
                          get: function () {
                              return t[o];
                          },
                      });
              }
            : function (e, t, o, i) {
                  void 0 === i && (i = o), (e[i] = t[o]);
              }),
    __setModuleDefault =
        (this && this.__setModuleDefault) ||
        (Object.create
            ? function (e, t) {
                  Object.defineProperty(e, "default", { enumerable: !0, value: t });
              }
            : function (e, t) {
                  e.default = t;
              }),
    __decorate =
        (this && this.__decorate) ||
        function (e, t, o, i) {
            var n,
                s = arguments.length,
                r = s < 3 ? t : null === i ? (i = Object.getOwnPropertyDescriptor(t, o)) : i;
            if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(e, t, o, i);
            else for (var a = e.length - 1; a >= 0; a--) (n = e[a]) && (r = (s < 3 ? n(r) : s > 3 ? n(t, o, r) : n(t, o)) || r);
            return s > 3 && r && Object.defineProperty(t, o, r), r;
        },
    __importStar =
        (this && this.__importStar) ||
        function (e) {
            if (e && e.__esModule) return e;
            var t = {};
            if (null != e) for (var o in e) "default" !== o && Object.prototype.hasOwnProperty.call(e, o) && __createBinding(t, e, o);
            return __setModuleDefault(t, e), t;
        },
    __importDefault =
        (this && this.__importDefault) ||
        function (e) {
            return e && e.__esModule ? e : { default: e };
        };
define([
    "require",
    "exports",
    "lit",
    "lit/decorators",
    "lit/directives/until",
    "TYPO3/CMS/Core/lit-helper",
    "TYPO3/CMS/IgBackendHelpers/Tree/CategoryTree",
    "TYPO3/CMS/Core/Ajax/AjaxRequest",
    "TYPO3/CMS/Backend/Storage/Persistent",
    "TYPO3/CMS/Backend/Module",
    "TYPO3/CMS/Backend/ContextMenu",
    "d3-selection",
    "TYPO3/CMS/Backend/Enum/KeyTypes",
    "TYPO3/CMS/Backend/SvgTree",
    "TYPO3/CMS/Backend/Tree/DragDrop",
    "TYPO3/CMS/Backend/Modal",
    "TYPO3/CMS/Backend/Severity",
    "TYPO3/CMS/Backend/Storage/ModuleStateStorage",
], function (e, t, o, i, n, s, r, a, d, l, h, p, c, g, u, m, v, f) {
    "use strict";
    Object.defineProperty(t, "__esModule", { value: !0 }),
        (t.CategoryTreeNavigationComponent = t.EditableCategoryTree = t.navigationComponentName = void 0),
        (a = __importDefault(a)),
        (d = __importDefault(d)),
        (p = __importStar(p)),
        (t.navigationComponentName = "typo3-backend-navigation-component-categorytree");
    let D = class extends r.CategoryTree {
        selectFirstNode() {
            this.selectNode(this.nodes[0], !0);
        }
        switchFocusNode(e) {
            this.nodeIsEdit || this.switchFocus(this.getNodeElement(e));
        }
        nodesUpdate(e) {
            return super.nodesUpdate.call(this, e);
        }
        updateNodeBgClass(e) {
            return super.updateNodeBgClass.call(this, e);
        }
        removeEditedText() {
            const e = p.selectAll(".node-edit");
            if (e.size())
                try {
                    e.remove(), (this.nodeIsEdit = !1);
                } catch (e) {}
        }
        appendTextElement(e) {
            let t = 0;
            return super.appendTextElement(e).on("click", (e, o) => {
                "0" !== o.identifier
                    ? 1 == ++t &&
                      setTimeout(() => {
                          1 === t ? this.selectNode(o, !0) : this.editNodeLabel(o), (t = 0);
                      }, 300)
                    : this.selectNode(o, !0);
            });
        }
        editNodeLabel(e) {
            e.allowEdit &&
                (this.removeEditedText(),
                (this.nodeIsEdit = !0),
                p
                    .select(this.svg.node().parentNode)
                    .append("input")
                    .attr("class", "node-edit")
                    .style("top", () => e.y + this.settings.marginTop + "px")
                    .style("left", e.x + this.textPosition + 5 + "px")
                    .style("width", this.settings.width - (e.x + this.textPosition + 20) + "px")
                    .style("height", this.settings.nodeHeight + "px")
                    .attr("type", "text")
                    .attr("value", e.name)
                    .on("keydown", (t) => {
                        const o = t.keyCode;
                        if (o === c.KeyTypesEnum.ENTER || o === c.KeyTypesEnum.TAB) {
                            const o = t.target.value.trim();
                            (this.nodeIsEdit = !1), this.removeEditedText(), o.length && o !== e.name && ((e.nameSourceField = e.nameSourceField || "title"), (e.newName = o), this.sendEditNodeLabelCommand(e));
                        } else o === c.KeyTypesEnum.ESCAPE && ((this.nodeIsEdit = !1), this.removeEditedText());
                    })
                    .on("blur", (t) => {
                        if (!this.nodeIsEdit) return;
                        const o = t.target.value.trim();
                        o.length && o !== e.name && ((e.nameSourceField = e.nameSourceField || "title"), (e.newName = o), this.sendEditNodeLabelCommand(e)), this.removeEditedText();
                    })
                    .node()
                    .select());
        }
    };
    (D = __decorate([i.customElement("typo3-backend-navigation-component-categorytree-tree")], D)), (t.EditableCategoryTree = D);
    let y = class extends o.LitElement {
        constructor() {
            super(...arguments),
                (this.mountPointPath = null),
                (this.configuration = null),
                (this.refresh = () => {
                    this.tree.refreshOrFilterTree();
                }),
                (this.setMountPoint = (e) => {
                    this.setTemporaryMountPoint(e.detail.pageId);
                }),
                (this.selectFirstNode = () => {
                    this.tree.selectFirstNode();
                }),
                (this.toggleExpandState = (e) => {
                    const t = e.detail.node;
                    t && d.default.set("BackendComponents.States.Categorytree." + t.extensionName + ".stateHash." + t.stateIdentifier, t.expanded ? "1" : "0");
                }),
                (this.loadContent = (e) => {
                    const t = e.detail.node;
                    if (!(null == t ? void 0 : t.checked)) return;
                    if ((f.ModuleStateStorage.update("web", t.identifier, !0, t.stateIdentifier.split('_')[0]), !1 === e.detail.propagate)) return;
                    const o = top.TYPO3.ModuleMenu.App;
                    let i = l.getRecordFromName(o.getCurrentModule()).link;
                    (i += i.includes("?") ? "&" : "?"), top.TYPO3.Backend.ContentContainer.setUrl(i + "id=" + t.pid + "&entryId=" + t.identifier);
                }),
                (this.selectActiveNode = (e) => {
                    const t = f.ModuleStateStorage.current("web").selection;
                    let o = e.detail.nodes;
                    e.detail.nodes = o.map((e) => (e.stateIdentifier === t && (e.checked = !0), e));
                });
        }
        connectedCallback() {
            super.connectedCallback(),
                document.addEventListener("typo3:categorytree:refresh", this.refresh),
                document.addEventListener("typo3:categorytree:mountPoint", this.setMountPoint),
                document.addEventListener("typo3:categorytree:selectFirstNode", this.selectFirstNode);
        }
        disconnectedCallback() {
            document.removeEventListener("typo3:categorytree:refresh", this.refresh),
                document.removeEventListener("typo3:categorytree:mountPoint", this.setMountPoint),
                document.removeEventListener("typo3:categorytree:selectFirstNode", this.selectFirstNode),
                super.disconnectedCallback();
        }
        createRenderRoot() {
            return this;
        }
        render() {
            return o.html`
      <div id="typo3-categorytree" class="svg-tree">
        ${n.until(this.renderTree(), this.renderLoader())}
      </div>
    `;
        }
        getConfiguration() {
            if (null !== this.configuration) return Promise.resolve(this.configuration);
            let tableType = top.TYPO3.settings.tableType;
            if(!tableType) {
                tableType = 'category';
            }
            const extensionName = top.currentModuleLoaded.split('_')[0];
            const extensionNameLowerCase = extensionName.toLowerCase();
            const e = top.TYPO3.settings.ajaxUrls[extensionNameLowerCase + '_' + tableType  + '_tree_configuration'];
            return new a.default(e).get().then(async (e) => {
                const t = await e.resolve("json");
                return (this.configuration = t), (this.mountPointPath = t.temporaryMountPoint || null), t;
            });
        }
        renderTree() {
            return this.getConfiguration().then(
                (e) => o.html`
          <div>
            <typo3-backend-navigation-component-categorytree-toolbar id="typo3-categorytree-toolbar" class="svg-toolbar" .tree="${this.tree}"></typo3-backend-navigation-component-categorytree-toolbar>
            <div id="typo3-categorytree-treeContainer" class="navigation-tree-container">
              ${this.renderMountPoint()}
              <typo3-backend-navigation-component-categorytree-tree id="typo3-categorytree-tree" class="svg-tree-wrapper" .setup=${e} @svg-tree:initialized=${() => {
                        (this.toolbar.tree = this.tree),
                        this.tree.addEventListener("typo3:svg-tree:expand-toggle", this.toggleExpandState),
                        this.tree.addEventListener("typo3:svg-tree:node-selected", this.loadContent),
                        this.tree.addEventListener("typo3:svg-tree:nodes-prepared", this.selectActiveNode);
                }}></typo3-backend-navigation-component-categorytree-tree>
            </div>
          </div>
          ${this.renderLoader()}
        `
            );
        }
        renderLoader() {
            return o.html`
      <div class="svg-tree-loader">
        <typo3-backend-icon identifier="spinner-circle-light" size="large"></typo3-backend-icon>
      </div>
    `;
        }
        unsetTemporaryMountPoint() {
            (this.mountPointPath = null),
                d.default.unset("categoryTree_temporaryMountPoint").then(() => {
                    this.tree.refreshTree();
                });
        }
        renderMountPoint() {
            return null === this.mountPointPath
                ? o.html``
                : o.html`
      <div class="node-mount-point">
        <div class="node-mount-point__icon"><typo3-backend-icon identifier="actions-document-info" size="small"></typo3-backend-icon></div>
        <div class="node-mount-point__text">${this.mountPointPath}</div>
        <div class="node-mount-point__icon mountpoint-close" @click="${() => this.unsetTemporaryMountPoint()}" title="${s.lll("labels.temporaryDBmount")}">
          <typo3-backend-icon identifier="actions-close" size="small"></typo3-backend-icon>
        </div>
      </div>
    `;
        }
        setTemporaryMountPoint(e) {
            new a.default(this.configuration.setTemporaryMountPointUrl)
                .post("pid=" + e, { headers: { "Content-Type": "application/x-www-form-urlencoded", "X-Requested-With": "XMLHttpRequest" } })
                .then((e) => e.resolve())
                .then((e) => {
                    e && e.hasErrors ? (this.tree.errorNotification(e.message, !0), this.tree.updateVisibleNodes()) : ((this.mountPointPath = e.mountPointPath), this.tree.refreshOrFilterTree());
                })
                .catch((e) => {
                    this.tree.errorNotification(e, !0);
                });
        }
    };
    __decorate([i.property({ type: String })], y.prototype, "mountPointPath", void 0),
        __decorate([i.query(".svg-tree-wrapper")], y.prototype, "tree", void 0),
        __decorate([i.query("typo3-backend-navigation-component-categorytree-toolbar")], y.prototype, "toolbar", void 0),
        (y = __decorate([i.customElement(t.navigationComponentName)], y)),
        (t.CategoryTreeNavigationComponent = y);
    let b = class extends g.Toolbar {
        constructor() {
            super(...arguments), (this.tree = null);
        }
        render() {
            var e, t, i;
            return o.html`
      <div class="tree-toolbar">
        <div class="svg-toolbar__menu">
          <div class="svg-toolbar__search">
              <input type="search" class="form-control form-control-sm search-input" placeholder="${s.lll("tree.searchTermInfo")}">
          </div>
        </div>
        <div class="svg-toolbar__submenu">
          ${
              (null === (i = null === (t = null === (e = this.tree) || void 0 === e ? void 0 : e.settings) || void 0 === t ? void 0 : t.doktypes) || void 0 === i ? void 0 : i.length)
                  ? this.tree.settings.doktypes.map(
                        (e) => o.html`
                <div class="svg-toolbar__menuitem svg-toolbar__drag-node" data-tree-icon="${e.icon}" data-node-type="${e.nodeType}"
                     title="${e.title}" tooltip="${e.tooltip}">
                  <typo3-backend-icon identifier="${e.icon}" size="small"></typo3-backend-icon>
                </div>
              `
                    )
                  : ""
          }
          <a class="svg-toolbar__menuitem nav-link dropdown-toggle dropdown-toggle-no-chevron float-end" data-bs-toggle="dropdown" href="#" role="button" aria-expanded="false"><typo3-backend-icon identifier="actions-menu-alternative" size="small"></typo3-backend-icon></a>
          <ul class="dropdown-menu dropdown-menu-end">
            <li>
              <button class="dropdown-item" @click="${() => this.refreshTree()}">
                <typo3-backend-icon identifier="actions-refresh" size="small" class="icon icon-size-small"></typo3-backend-icon>
                ${s.lll("labels.refresh")}
              </button>
            </li>
            <li>
              <button class="dropdown-item" @click="${(e) => this.collapseAll(e)}">
                <typo3-backend-icon identifier="apps-pagetree-category-collapse-all" size="small" class="icon icon-size-small"></typo3-backend-icon>
                ${s.lll("labels.collapse")}
              </button>
            </li>
          </ul>
        </div>
      </div>
    `;
        }
    };
    __decorate([i.property({ type: D })], b.prototype, "tree", void 0), (b = __decorate([i.customElement("typo3-backend-navigation-component-categorytree-toolbar")], b));
});
