<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Controller;


use TYPO3\CMS\Fluid\View\TemplateView;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchActionException;
use Internetgalerie\IgBackendHelpers\View\TableTreeView;
use Internetgalerie\IgBackendHelpers\View\TableListView;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContext;
use ReflectionClass;
use TYPO3\CMS\Extbase\Mvc\View\NotFoundView;
use TYPO3\CMS\Fluid\View\TemplatePaths;
use TYPO3\CMS\Core\Http\NormalizedParams;
use Internetgalerie\IgBackendHelpers\Utility\BackendFrameUtility;
use Internetgalerie\IgBackendHelpers\View\PageTreeView;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Backend\Template\Components\ButtonBar;
use TYPO3\CMS\Backend\Template\ModuleTemplate;
use TYPO3\CMS\Core\Authentication\BackendUserAuthentication;
use TYPO3\CMS\Core\Http\HtmlResponse;
use TYPO3\CMS\Core\Http\JsonResponse;
use TYPO3\CMS\Core\Imaging\Icon;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Localization\LanguageService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\View\ViewInterface;

/**
 * Main script class for rendering of the folder tree
 *
 * @internal This class is a specific Backend controller implementation and is not considered part of the Public TYPO3 API.
 */
class AbstractNavigationFrameController
{
    
    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManagerInterface
     */
    protected $objectManager;

    /**
     * Current ServerRequestInterface
     */
    protected $request = null;

    /**
     * Name of the action method
     * @var string
     */
    protected $actionMethodName = 'indexAction';

    /**
     * table name to use
     * @var string|null
     */
    protected $tableName = null;

    /**
     * Mount Pages
     * @var array
     */
    protected $mountPointPages = [];

    /**
     * Name of the main Module
     *
     * @var string
     */

    /**
     * The current view, as resolved by resolveView()
     */
    protected $view = null;

    /**
     * The default view object to use if none of the resolved views can render
     * a response for the current request.
     */
    protected $defaultViewObjectName = TemplateView::class;

    /**
     * Content accumulates in this variable.
     */
    protected $content;

    protected $foldertree = null;

    protected $currentSubScript;

    protected $cMR;

    /**
     * @var array
     */
    protected $scopeData;

    /**
     * ModuleTemplate Container
     */
    protected $moduleTemplate;

    /**
     * Additional clause for selecting pages e.g. 'AND doktype=254' for all system folders
     */
    protected $additionalSqlWhere = '';

    /**
     * extensionName Current ExtensionName for TypoScript Settings - must beend set for view output
     */
    protected $extensionName = null;

    /**
     * treeViewClassname
     */
    protected $treeViewClassname = PageTreeView::class;

    /**
     * @var BackendFrameUtility $backendFrameUtility
     */
    protected $backendFrameUtility = null;


    /**
     * Constructs the controller.
     */
    public function __construct()
    {
        if($this->extensionName===null ) {
            $className = static::class;
            $classNameParts = explode('\\', $className, 4);
            // Skip vendor and product name for core classes
            if (str_starts_with($className, 'TYPO3\\CMS\\')) {
                $this->extensionName = $classNameParts[2];
            } else {
                $this->extensionName = $classNameParts[1];
            }
        }
    }

    /**
     * @param ConfigurationManagerInterface $configurationManager
     */
    /*  public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
        {
        $this->configurationManager = $configurationManager;
        $this->settings = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS);
        }
    */
    /**
     * Injects the object manager
     *
     * @param \TYPO3\CMS\Extbase\Object\ObjectManagerInterface $objectManager
     */
    /*  public function injectObjectManager(\TYPO3\CMS\Extbase\Object\ObjectManagerInterface $objectManager)
        {
        $this->objectManager = $objectManager;
        $this->arguments = $this->objectManager->get(\TYPO3\CMS\Extbase\Mvc\Controller\Arguments::class);
        }
    */

    /**
     * @param  ServerRequestInterface $request the current request
     *
     * @return ResponseInterface the response with the content
     */
    public function routeAction(ServerRequestInterface $request): ResponseInterface
    {
        $this->objectManager = GeneralUtility::makeInstance(ObjectManager::class);
        $this->configurationManager = $this->objectManager->get(ConfigurationManagerInterface::class);
        //$this->settings = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS);
        $this->init($request);
        $this->actionMethodName = $this->resolveActionMethodName();
        $this->backendFrameUtility = $this->objectManager->get(BackendFrameUtility::class);
        $this->initializeMountPoints();
        $this->initializeAction();
        $actionInitializationMethodName = 'initialize' . ucfirst($this->actionMethodName);
        if (method_exists($this, $actionInitializationMethodName)) {
            call_user_func([$this, $actionInitializationMethodName]);
        }
        $this->initFolderTree();
        $this->initializePageTemplate();
        if (! empty($this->extensionName)) {
            $this->view = $this->resolveView();
        }
        /*
          if ($this->view !== null) {
          $this->initializeView($this->view);
          }
        */
        return $this->callActionMethod();

        //return new HtmlResponse($content);
    }

    /**
     * Makes the AJAX call to expand or collapse the foldertree.
     * Called by an AJAX Route, see AjaxRequestHandler
     */
    public function ajaxExpandCollapse(ServerRequestInterface $request): ResponseInterface
    {
        $this->init($request);
        $tree = $this->foldertree->getBrowsableTree(0);
        if ($this->foldertree->getAjaxStatus() === false) {
            return new JsonResponse(null, 500);
        }
        return new JsonResponse([$tree]);
    }


    /**
     * Initialization of the script class
     *
     * @param ServerRequestInterface $request the current request
     */
    protected function init(ServerRequestInterface $request): void
    {
        $this->request = $request;
        $this->moduleTemplate = GeneralUtility::makeInstance(ModuleTemplate::class);

        $parsedBody = $request->getParsedBody();
        $this->queryParams = $request->getQueryParams();

        $this->currentSubScript = $parsedBody['currentSubScript'] ?? $this->queryParams['currentSubScript'] ?? null;
        $this->cMR = (bool) ($parsedBody['cMR'] ?? $this->queryParams['cMR'] ?? false);
        $scopeData = $parsedBody['scopeData'] ?? $this->queryParams['scopeData'] ?? '';
        $scopeHash = $parsedBody['scopeHash'] ?? $this->queryParams['scopeHash'] ?? '';

        if (! empty($scopeData) && hash_equals(GeneralUtility::hmac($scopeData), $scopeHash)) {
            $this->scopeData = unserialize($scopeData);
        }
    }
    protected function initFolderTree(): void
    {
        // Create folder tree object:
        /*
          if (!empty($this->scopeData)) {
          $this->foldertree = GeneralUtility::makeInstance($this->scopeData['class']);
          $this->foldertree->thisScript = $this->scopeData['script'];
          if ($this->foldertree instanceof ElementBrowserFolderTreeView) {
          // create a fake provider to pass link data along properly
          $linkParamProvider = GeneralUtility::makeInstance(
          DummyLinkParameterProvider::class,
          $this->scopeData['browser'],
          $this->scopeData['script']
          );
          $this->foldertree->setLinkParameterProvider($linkParamProvider);
          }
          } else {
          }
        */
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        if ($this->foldertree === null) {
            $this->foldertree = GeneralUtility::makeInstance($this->treeViewClassname, $this->additionalSqlWhere);
        }
        //$this->foldertree = GeneralUtility::makeInstance(PageTreeView::class, $this->additionalSqlWhere);
        //var_dump($queryParams);exit(0);
        // fix for typo3 10
        $route = str_replace('/module/', '', $this->queryParams['route']);
        $this->foldertree->thisScript = (string) $uriBuilder->buildUriFromRoute(trim($route, '/'), $this->queryParams);
        //$this->foldertree->mainModule=$this->mainModule;
    }

    protected function initializeMountPoints(): void
    {
        //Array of all uids of system folders with "Enthält Erweiterung" = '$this->extensionName'
        $this->mountPointPages = $this->backendFrameUtility->getSysFolderByModule( $this->extensionName );
    }
    /**
     * Initialization for the visual parts of the class
     * Use template rendering only if this is a non-AJAX call
     */
    protected function initializePageTemplate(): void
    {
        $this->moduleTemplate->setBodyTag('<body id="ext-backend-Modules-NavigationFrame-index-php">');

        // Adding javascript code for drag&drop and the file tree as well as the click menu code
        $hlClass = $this->getBackendUser()->workspace === 0 ? 'active' : 'active active-ws wsver' . $GLOBALS['BE_USER']->workspace;
        if (method_exists($this->foldertree, 'getDragDropCode')) {
            $dragDropCode = $this->foldertree->getDragDropCode($hlClass);
        } else {
            $dragDropCode = '
            Tree.highlightClass = "' . $hlClass . '";
            Tree.highlightActiveItem("", top.fsMod.navFrameHighlightedID["web"]);
        ';
        }
        // Adding javascript for drag & drop activation and highlighting
        $pageRenderer = $this->moduleTemplate->getPageRenderer();
        $pageRenderer->loadRequireJsModule('TYPO3/CMS/Backend/ContextMenu');
        $pageRenderer->loadRequireJsModule(
            'TYPO3/CMS/Backend/LegacyTree', 'function() {
            DragDrop.table = "folders";
            Tree.registerDragDropHandlers();
            ' . $dragDropCode . '
        }'
        );

        $inlineJs = ($this->currentSubScript ? 'top.currentSubScript=unescape("' . rawurlencode((string) $this->currentSubScript) . '");' : '');
        if (method_exists($this->foldertree, 'getJumpToScript')) {
            $inlineJs .= $this->foldertree->getJumpToScript($this->cMR);
        } else {
            // Setting JavaScript for menu.
            $inlineJs .= '
        // Function, loading the list frame from navigation tree:
        function jumpTo(id, linkObj, highlightID, bank) {
            var theUrl = top.currentSubScript;
            if (theUrl.indexOf("?") != -1) {
                theUrl += "&id=" + id
            } else {
                theUrl += "?id=" + id
            }
            top.fsMod.currentBank = bank;
            top.TYPO3.Backend.ContentContainer.setUrl(theUrl);

            Tree.highlightActiveItem("file", highlightID + "_" + bank);
            if (linkObj) { linkObj.blur(); }
            return false;
        }
        ' . ($this->cMR ? ' jumpTo(top.fsMod.recentIds[\'web\'],\'\');' : '');
        }

        $this->moduleTemplate->getPageRenderer()->addJsInlineCode(
            'NavigationFrame',
            $inlineJs
        );
    }

    /**
     * Register docHeader buttons
     */
    protected function getButtons(ServerRequestInterface $request): void
    {
        /**
         * @var ButtonBar $buttonBar
         */
        $buttonBar = $this->moduleTemplate->getDocHeaderComponent()->getButtonBar();
        /**
         * @var IconFactory $iconFactory
         */
        $iconFactory = $this->moduleTemplate->getIconFactory();
        /**
         * @var NormalizedParams
         */
        $normalizedParams = $request->getAttribute('normalizedParams');

        // Refresh
        $refreshButton = $buttonBar->makeLinkButton()
                                   ->setHref($normalizedParams->getRequestUri())
                                   ->setTitle($this->getLanguageService()->sL('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:labels.reload'))
                                   ->setIcon($iconFactory->getIcon('actions-refresh', Icon::SIZE_SMALL));
        $buttonBar->addButton($refreshButton, ButtonBar::BUTTON_POSITION_RIGHT);

        //$this->getHelpButton();
        // CSH - Help Button
        /*
          $cshButton = $buttonBar->makeHelpButton()
          ->setModuleName('xMOD_csh_corebe')
          ->setFieldName('filetree');
          $buttonBar->addButton($cshButton);
        */
    }

    /**
     * Resolves and checks the current action method name
     *
     * @return string Method name of the current action
     *
     * @throws NoSuchActionException if the action specified in the request object does not exist (and if there's no default action either).
     */
    protected function resolveActionMethodName(): string
    {
        $this->action = ($this->request->getQueryParams()['action'] ?? 'index');
        $actionMethodName = $this->action . 'Action';
        if (! method_exists($this, $actionMethodName)) {
            throw new NoSuchActionException('An action "' . $actionMethodName . '" does not exist in controller "' . static::class . '".', 1186669086);
        }
        return $actionMethodName;
    }

    /**
     * Initializes the controller before invoking an action method.
     *
     * Override this method to solve tasks which all actions have in
     * common.
     */
    protected function initializeAction(): void
    {
    }

    /**
     * Calls the specified action method and passes the arguments.
     *
     * If the action returns a string, it is appended to the content in the
     * response object. If the action doesn't return anything and a valid
     * view exists, the view is rendered automatically.
     */
    protected function callActionMethod()
    {
        $actionResult = $this->{$this->actionMethodName}();
        if ($actionResult === null) {
            if ($this->view instanceof ViewInterface) {
                $actionResult = $this->view->render();
            } else {
                $actionResult = empty($this->extensionName) ? 'protected $extensionName = \'EXTKEY\'; must be defined in controller class or return a string' : '';
            }
            //return new HtmlResponse($this->view->render());
            //$this->response->appendContent($this->view->render());
        }

        $this->moduleTemplate->setContent($actionResult);
        // Setting up the buttons
        $this->getButtons($this->request);
        // Build the <body> for the module
        $this->moduleTemplate->setTitle('TYPO3 Folder Tree');
        $this->content = $this->moduleTemplate->renderContent();
        //$this->response->appendContent($this->content);
        return new HtmlResponse($this->content);
        /*
          if ($actionResult === null && $this->view instanceof ViewInterface) {
          $this->response->appendContent($this->view->render());
          } elseif (is_string($actionResult) && $actionResult !== '') {
          $this->response->appendContent($actionResult);
          } elseif (is_object($actionResult) && method_exists($actionResult, '__toString')) {
          $this->response->appendContent((string)$actionResult);
          }
        */
    }
    public function getPageSelect()
    {
        // if not set, the mount point of the backend user is used
        //$this->foldertree->setPageUid($this->mountPointUids[0]);
        $count = count($this->mountPointPages);

        if($count==1) {        
            return '<input type="hidden" id="pageUid" name="id" value="'.$this->mountPointPages[0]['uid'].'">';
        } else if($count>1) {
            $options = '';
            foreach($this->mountPointPages as $page) {
                //  ' . ($page['uid']==$this->id ? ' selected=""' : '' ) . '
                $options .= '<option value="' . $page['uid'] . '">' . htmlspecialchars((string) $page['title']) . ' (' . $page['uid'] . ')</option>';
            }
            //$iconFactory = $this->moduleTemplate->getIconFactory(); ' . $iconFactory->getIcon('module-page', Icon::SIZE_SMALL). '
            return '<div class="row search-bar"><select id="pageUid" name="id" class="form-control">' . $options . '</select></div>';
        } else {
            return 'no system folder with "'. $this->extensionName . '" found';
        }
    }
    
    public function pageTreeAction()
    {

        // if not set, the mount point of the backend user is used
        $this->foldertree->setMounts(array_column($this->mountPointPages, 'uid'));

        // Tree als HTML
        return $this->foldertree->getBrowsableTree(1); // Max deepth of the tree
    }

    public function initializeTableTreeAction(): void
    {
        // Welcher TreeView soll verwendet werden, default ist
        $this->foldertree = GeneralUtility::makeInstance( TableTreeView::class);
        // Suchparameter Name mit dem der Backend Controllen/Module aufgerufen wird, Link geschieht auf Seite des pid des Eintrages und uid mit diesem Suchparameter Namen
        $this->foldertree->setTable($this->tableName);
        // set MainModule to save current state in top frame of browser
        $this->foldertree->setMainModule($this->extensionName);
    }
    public function tableTreeAction()
    {

        $pageSelect = $this->getPageSelect();

        // Tree als HTML
        return $pageSelect . $this->foldertree->getBrowsableTree();
    }
    

    public function initializeTableListAction(): void
    {
        // Welcher TreeView soll verwendet werden, default ist
        $this->foldertree = GeneralUtility::makeInstance( TableListView::class);
        // Suchparameter Name mit dem der Backend Controllen/Module aufgerufen wird, Link geschieht auf Seite des pid des Eintrages und uid mit diesem Suchparameter Namen
        $this->foldertree->setTable($this->tableName);
        // set MainModule to save current state in top frame of browser
        $this->foldertree->setMainModule($this->extensionName);
    }
    public function tableListAction()
    {
        $pageSelect = $this->getPageSelect();
        
        // Tree als HTML
        return $pageSelect . $this->foldertree->getBrowsableList();
    }
    
    /**
     * Prepares a view for the current action.
     * By default, this method tries to locate a view with a name matching the current action.
     */
    protected function resolveView(): ViewInterface
    {
        $view = null;
        if ($this->defaultViewObjectName !== '') {
            /**
             * @var ViewInterface $view
             */
            $view = $this->objectManager->get($this->defaultViewObjectName);
            $context = new RenderingContext($view);
            //$context = new \TYPO3\CMS\Fluid\Core\Rendering\RenderingContext($view);

            //var_dump(static::class);
            $controllerClassName = (new ReflectionClass($this))->getShortName();
            $strLen = strlen('Controller');
            if (! \str_ends_with($controllerClassName, 'Controller')) {
                // maybe error????
                $controllerClassNameWithoutControllerSuffix = $controllerClassName;
            } else {
                $controllerClassNameWithoutControllerSuffix = substr($controllerClassName, 0, -$strLen);
            }
            $context->setControllerName($controllerClassNameWithoutControllerSuffix);

            $context->setControllerAction(ucfirst($this->action));
            $view->setRenderingContext($context);
            $this->setViewConfiguration($view);
        }
        if (! isset($view)) {
            $view = $this->objectManager->get(NotFoundView::class);
            $view->assign(
                'errorMessage', 'No template was found. View could not be resolved for action "'
                . $this->request->getControllerActionName() . '" in class "' . $this->request->getControllerObjectName() . '"'
            );
        }
        //$view->setControllerContext($this->controllerContext);
        if (method_exists($view, 'injectSettings')) {
            $view->injectSettings($this->settings);
        }
        $view->initializeView();
        // In TYPO3.Flow, solved through Object Lifecycle methods, we need to call it explicitly
        $view->assign('settings', $this->settings);
        // same with settings injection.
        return $view;
    }

    protected function setViewConfiguration(ViewInterface $view): void
    {
        // Template Path Override

        /*$extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(
          ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
          );
          $configuration=$this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);
          //echo( $this->extensionName);exit(0);
          var_dump($this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK, $this->extensionName, $this->pluginName));exit(0);

          var_dump($extbaseFrameworkConfiguration);exit(0);
        */
        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK,
            $this->extensionName
        );
        $templatePaths = new TemplatePaths($extbaseFrameworkConfiguration);
        foreach (['templateRootPaths', 'partialRootPaths', 'layoutRootPaths'] as $setting) {
            if (is_array($extbaseFrameworkConfiguration['view'][$setting])) {
                foreach ($extbaseFrameworkConfiguration['view'][$setting] as $id => &$path) {
                    $path = GeneralUtility::getFileAbsFileName($path);
                }
            }
        }
        // widget is missing !

        //var_dump($extbaseFrameworkConfiguration['view']);exit(0);

        // set TemplateRootPaths
        $viewFunctionName = 'setTemplateRootPaths';
        if (method_exists($view, $viewFunctionName)) {
            $setting = 'templateRootPaths';
            $parameter = $this->getViewProperty($extbaseFrameworkConfiguration, $setting);
            // no need to bother if there is nothing to set
            if ($parameter) {
                $view->$viewFunctionName($parameter);
            }
        }

        // set LayoutRootPaths
        $viewFunctionName = 'setLayoutRootPaths';
        if (method_exists($view, $viewFunctionName)) {
            $setting = 'layoutRootPaths';
            $parameter = $this->getViewProperty($extbaseFrameworkConfiguration, $setting);
            // no need to bother if there is nothing to set
            if ($parameter) {
                $view->$viewFunctionName($parameter);
            }
        }
        // set PartialRootPaths
        $viewFunctionName = 'setPartialRootPaths';
        if (method_exists($view, $viewFunctionName)) {
            $setting = 'partialRootPaths';
            $parameter = $this->getViewProperty($extbaseFrameworkConfiguration, $setting);
            // no need to bother if there is nothing to set
            if ($parameter) {
                $view->$viewFunctionName($parameter);
            }
        }
    }

    /**
     * Handles the path resolving for *rootPath(s)
     *
     * numerical arrays get ordered by key ascending
     *
     * @param array  $extbaseFrameworkConfiguration
     * @param string $setting                       parameter name from TypoScript
     *
     * @return array
     */
    protected function getViewProperty(array $extbaseFrameworkConfiguration, string $setting): array
    {
        $values = [];
        if (! empty($extbaseFrameworkConfiguration['view'][$setting])
            && is_array($extbaseFrameworkConfiguration['view'][$setting])
        ) {
            $values = $extbaseFrameworkConfiguration['view'][$setting];
        }

        return $values;
    }

    protected function getBackendUser(): BackendUserAuthentication
    {
        return $GLOBALS['BE_USER'];
    }

    /**
     * Returns an instance of LanguageService
     */
    protected function getLanguageService(): LanguageService
    {
        return $GLOBALS['LANG'];
    }
}
