<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Utility;

use Doctrine\DBAL\ArrayParameterType;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Utilities to manage main modules of an extension
 */
class BackendFrameUtility
{
    /**
     * Get all sysfolder with given module name
     */
    public function getSysFolderByModule(string $moduleName): array
    {
        return $this->getSysFolderByModules([$moduleName]);
    }
    /**
     * Get all sysfolder with given module names
     */
    public function getSysFolderByModules(array $ModuleArray): array
    {
        if (is_string($ModuleArray)) {
            $ModuleArray = [$ModuleArray];
        }

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('pages');
        $queryBuilder
            ->getRestrictions()
            ->removeAll()
            ->add(GeneralUtility::makeInstance(DeletedRestriction::class));

        $statement = $queryBuilder
                   ->select('uid', 'title')
                   ->from('pages')
                   ->where(
                       $queryBuilder->expr()->eq(
                           'doktype',
                           '254'
                       )
                   )
                   ->andWhere(
                       $queryBuilder->expr()->eq(
                           'sys_language_uid',
                           '0'
                       )
                   )
                   ->andWhere(
                       $queryBuilder->expr()->in(
                           'module',
                           $queryBuilder->createNamedParameter(
                               $ModuleArray,
                               ArrayParameterType::STRING
                           )
                       )
                   )
                   ->orderBy('title')
                   ->executeQuery();
        $userTsConfig = $GLOBALS['BE_USER']->getTSConfig();
        $frameConfig = [];
        foreach($ModuleArray as $moduleName) {
            if($userTsConfig['options.']['backendFrame.'][$moduleName . '.'] ?? null && is_array($userTsConfig['options.']['backendFrame.'][$moduleName . '.'])) {
                $frameConfig = array_merge($frameConfig, $userTsConfig['options.']['backendFrame.'][$moduleName . '.']);
                break;
            }
        }
        $excludeUids = [];
        if(!empty($frameConfig['excludeUid'])) {
            $excludeUids = GeneralUtility::trimExplode(',', $frameConfig['excludeUid'], true); 
        }
        $pages = [];
        foreach($statement->fetchAllAssociative() as $page) {
            if($GLOBALS['BE_USER']->isInWebMount($page['uid']) && !in_array($page['uid'], $excludeUids)) {
                $pages[] = $page;
            }
        }
        return $pages;
    }

}