import{ModuleUtility} from "@typo3/backend/module.js";
import ModuleMenu from "@typo3/backend/module-menu.js";
import TriggerRequest from "@typo3/backend/event/trigger-request.js";
// Resources/Public/JavaScript/custom-module-behavior.js


class CustomModuleBehavior {
    static initialize() {
        // Wait for the module menu to be ready
        this.interceptModuleClicks();
    }
    
    static interceptModuleClicks() {
        // Find your specific module menu item
        const moduleLinks = document.querySelectorAll('.modulemenu-action');
        for(var moduleLink of moduleLinks) {
            const moduleIdentifier = moduleLink.dataset.modulemenuIdentifier;
            const extension = moduleIdentifier.split('_')[0];
            if (moduleLink) {
                moduleLink.addEventListener('click', (event) => {
                    this.loadCustomModule(event, extension, moduleIdentifier);
                });
            }
        }
    }
    
    static loadCustomModule(event, extension, moduleName) {
        const selection = this.getSelection(extension);
        const entryId = this.getEntryId(extension);
        // Build the URL with both parameters
        const params = new URLSearchParams();

        if(selection === null || typeof selection === "undefined" || entryId === null || typeof entryId === "undefined") {
            return;
        }
        event.preventDefault();
        event.stopPropagation();

        const moduleData = ModuleUtility.getFromName(moduleName);

        params.set('id', selection);
        params.set('entryId', entryId);
        // Navigate to the module
        top.TYPO3.ModuleMenu.App.openInContentContainer(
            moduleName,
            moduleData.link,
            params,
            new TriggerRequest("typo3.loadModuleComponents")
        );
    }
    
    static getSelection(extension) {
        return ModuleStateStorage.current(extension).mount?.split('_')[0];
    }
    
    static getEntryId(extension) {
        return ModuleStateStorage.current(extension).mount?.split('_')[1];
    }
}
CustomModuleBehavior.initialize();

export default CustomModuleBehavior;