<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\View;

//use TYPO3\CMS\Backend\Tree\View\AbstractTreeView;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Browse pages in Web module
 *
 * @internal This class is a TYPO3 Backend implementation and is not considered part of the Public TYPO3 API.
 */
class TableTreeView extends AbstractTreeView
{
    public $fieldArray = null;
    //public $defaultList = 'uid,pid,tstamp,sorting,deleted,parent';
    public $parentField = 'parent';
    public $rootLabel = 'Root';
    public $emptyLabel = '???';
    public $treeName = null; // @todo must be unique -> set from tablename
    public $labelAttributes = [];
    //    public $expandAll=true;

    /**
     * Name of the main Module, to store the current ids/url parameter
     */
    public $mainModule = 'web';
    /**
     * @var string|null
     */
    /**
     * Field for ORDER BY. Is set by function init.
     */
    public $orderByFields = null;
    /**
     * PageId
     */
    protected $pageUid = null;
    protected $argumentName = 'entryId'; // maybe default should be empty, name for url query parameter

    /**
     * Calls init functions
     *
     * @param string $clause        Additional clause for selecting pages (is added to  ' AND deleted=0 AND sys_language_uid IN (0,-1) ')
     * @param string $orderByFields record ORDER BY field
     */
    public function __construct(string $clause = '', string $orderByFields = '')
    {
        parent::__construct();
        $this->init($clause, $orderByFields);
    }
    /**
     * Initialize, setting what is necessary for browsing pages.
     * Using the current user.
     *
     * @param string $clause        Additional clause for selecting pages.
     * @param string $orderByFields record ORDER BY field
     */
    public function init($clause = '', $orderByFields = ''): void
    {
        // Setting BE_USER by default
        $this->BE_USER = $GLOBALS['BE_USER'];
        // Setting clause
        $this->clause = ' AND deleted=0 AND sys_language_uid IN (0,-1) ' .$clause;
        if ($orderByFields) {
            $this->orderByFields = $orderByFields;
        }
        if (! is_array($this->MOUNTS)) {
            // Dummy
            $this->MOUNTS = [0 => 0];
        }
        $this->title = $GLOBALS['TYPO3_CONF_VARS']['SYS']['sitename'];

        // This will hide records from display - it has nothing to do with user rights!!
        //$clauseExcludePidList = '';
        // This is very important for making trees of pages: Filtering out deleted pages, pages with no access to and sorting them correctly:
        //parent::init(' AND deleted=0 AND sys_language_uid IN (0,-1) ' . $clause . $clauseExcludePidList, $orderByFields);
        //$this->treeName = str_replace('_', '', $this->treeName ?: $this->table);

        //$this->MOUNTS = [0];//$backendUser->returnWebmounts();
    }

    /**
     * set root uids for entries
     *
     * @param array $rootUids array of
     */
    public function setMounts(array $rootUids): void
    {
        $this->MOUNTS = $rootUids;
    }
    /**
     * set page uid with entries
     *
     * @param array $pageUid page uid where the entries are (pid of entries)
     */
    public function setPageUid($pageUid): void
    {
        $this->pageUid = $pageUid;
    }

    /**
     * set the name of the main module for links
     *
     * @param string $mainModule name of the main module
     */
    public function setMainModule($mainModule): void
    {
        $this->mainModule = $mainModule;
    }

    /**
     * get the argument name
     */
    public function getArgumentName(): string
    {
        return $this->argumentName;
    }

    /**
     * set the argument name
     *
     * @param string $argumentName the argument name used by links to main module for passing the uid of the selected tree item - default 'entryId'
     */
    public function setArgumentName($argumentName): void
    {
        $this->argumentName = $argumentName;
    }
    /**
     *
     * Set source table
     *
     * @param string $table table name from DB
     */
    public function setTable($table): void
    {
        $this->table = $table;
        if ($this->treeName === null) {
            $this->treeName = str_replace('_', '', $this->table);
        }

        if ($this->orderByFields === null) {
            $this->orderByFields = $GLOBALS['TCA'][$table]['ctrl']['sortby'] ?? '';
        }
        if ($this->fieldArray === null) {
            $this->fieldArray = [
                'uid',
                'pid',
                'hidden',
                'starttime',
                'endtime',
                'parent',
                $GLOBALS['TCA'][$table]['ctrl']['label'],
            ];
            $this->labelAttributes = [ $GLOBALS['TCA'][$table]['ctrl']['label'] ];
            if ($GLOBALS['TCA'][$table]['ctrl']['label_alt']) {
                $this->fieldArray = array_merge(
                    $this->fieldArray,
                    GeneralUtility::trimExplode(',', $GLOBALS['TCA'][$table]['ctrl']['label_alt'], true)
                );
                $this->labelAttributes = array_merge($this->labelAttributes,  GeneralUtility::trimExplode(',', $GLOBALS['TCA'][$table]['ctrl']['label_alt'], true));
            }
            if ($GLOBALS['TCA'][$table]['ctrl']['sortby'] ?? false) {
                $this->fieldArray[] = $GLOBALS['TCA'][$table]['ctrl']['sortby'];
            }
        }
    }
    /**
     *
     * Set parent fieldname
     *
     * @param string $parentField attribute name from DB of field parent (default: parent)
     */
    public function setParentField($parentField): void
    {
        $this->parentField = $parentField;
    }
    /**
     *
     * Set order by - is set within setTable from TCA
     *
     * @param string $orderBy special order by
     */
    public function setOrderBy($orderBy): void
    {
        $this->orderByFields = $orderBy;
    }
    /**
     *
     * Set where - default is " AND deleted=0 AND sys_language_uid IN (0,-1)"
     *
     * @param string $where addition where
     */
    public function setWhere($where): void
    {
        $this->clause = $where;
    }
    /**
     *
     * set attributes which are fetched from database
     *
     * @param array $fieldArray attributes which are fetched from database
     */
    public function setFieldArray($fieldArray): void
    {
        $this->fieldArray = $fieldArray;
    }
    /**
     *
     * sets if first item is expanded
     *
     * @param bool $expandFirst first item is expanded
     */
    public function setEpandFirst($expandFirst): void
    {
        $this->expandFirst = $expandFirst;
    }
    /**
     *
     * sets if all  item are expanded
     *
     * @param bool $expandAll should all item are expanded
     */
    public function setExpandAll($expandAll): void
    {
        $this->expandAll = $expandAll;
    }
    /**
     *
     * sets the tree name must be unique (caching) - set in setTable to table name without _
     *
     * @param string $treeName the tree name
     */
    public function setTreeName($treeName): void
    {
        $this->treeName = $treeName;
    }
    /**
     * get the current root label
     */
    public function getRootLabel(): string
    {
        return $this->rootLabel;
    }
    /**
     *
     * Set root label (label of the root item) defualt: Root
     *
     * @param string $rootLabel the label of the root item
     */
    public function setRootLabel(string $rootLabel): void
    {
        $this->rootLabel = $rootLabel;
    }
    /**
     * get the label used if the label of an item is empty
     */
    public function getEmptyLabel(): string
    {
        return $this->emptyLabel;
    }
    /**
     * set the label used if the label of an item is empty (default: ???)
     *
     * @param string $emptyLabel the label if no label is set
     */
    public function setEmptyLabel(string $emptyLabel): void
    {
        $this->emptyLabel = $emptyLabel;
    }

    /**
     * copy of original getBrowsableTree with the possibility to set the max deep
     * Will create and return the HTML code for a browsable tree
     * Is based on the mounts found in the internal array ->MOUNTS (set in the constructor)
     *
     * @param  int $deep max deep of the tree (0= only moountPoints)
     *
     * @return string HTML code for the browsable tree
     */
    public function getBrowsableTree(int $deep = 999): string
    {

        // Get stored tree structure AND updating it if needed according to incoming PM GET var.
        $this->initializePositionSaving();
        // Init done:
        $treeArr = [];
        // Traverse mounts:
        $firstHtml = '';
        foreach ($this->MOUNTS as $idx => $uid) {
            // Set first:
            $this->bank = $idx;
            $isOpen = $this->stored[$idx][$uid] || $this->expandFirst || $uid === '0' || $uid === 0;

            // Save ids while resetting everything else.
            $curIds = $this->ids;
            $this->reset();
            $this->ids = $curIds;
            // Only, if not for uid 0
            if ($uid) {
                // Set PM icon for root of mount:
                $cmd = $this->bank . '_' . ($isOpen ? '0_' : '1_') . $uid . '_' . $this->treeName;
                $firstHtml = '<a class="list-tree-control list-tree-control-' . ($isOpen ? 'open' : 'closed')
                    . '" href="' . htmlspecialchars($this->getThisScript() . 'PM=' . $cmd) . '"><i class="fa"></i></a>';
            }
            // Preparing rootRec for the mount
            if ($uid) {
                $rootRec = $this->getRecord($uid);
                $firstHtml .= $this->getIcon($rootRec);
            } else {
                // Artificial record for the tree root, id=0
                $rootRec = $this->getRootRecord();
                $firstHtml .= $this->getRootIcon($rootRec);
            }
            if (is_array($rootRec)) {
                // In case it was swapped inside getRecord due to workspaces.
                $uid = $rootRec['uid'];
                // Add the root of the mount to ->tree
                $this->tree[] = ['HTML' => $firstHtml, 'row' => $rootRec, 'bank' => $this->bank, 'hasSub' => true, 'invertedDepth' => 1000];
                // If the mount is expanded, go down:

                if ($isOpen) {
                    // Set depth:
                    if ($this->addSelfId) {
                        $this->ids[] = $uid;
                    }
                    if ($deep > 0 && $this->parentField) {
                        $this->getTree($uid, $deep);
                    }
                }
                // Add tree:
                $treeArr = array_merge($treeArr, $this->tree);
            }
        }
        return $this->printTree($treeArr);
    }

    /**
     * Returns the title for the input record. If blank, a "no title" label (localized) will be returned.
     * Do NOT htmlspecialchar the string from this function - has already been done.
     *
     * @param  array $row      The input row array (where the key "title" is used for the title)
     * @param  int   $titleLen Title length (30)
     *
     * @return string The title.
     */
    public function getTitleStr($row, $titleLen = 30)
    {
        if(is_array($row) && isset($row['uid']) && $row['uid']!=0) {
            foreach($this->labelAttributes as $labelAttribute) {
                if (isset($row[$labelAttribute])) {
                    $label = $row[$labelAttribute];
                    return substr(trim((string) $label), 0, $titleLen);
                }
            }
            return $this->emptyLabel;
        } else {
            return $this->rootLabel;
        }
    }

    /**
     * Wrapping $title in a-tags.
     *
     * @param    string $title Title string
     * @param    array  $row   Item record
     * @param    int    $bank  Bank pointer (which mount point number)
     *
     * @internal
     */
    public function wrapTitle($title, $row, $bank = 0)
    {
        //if($row['uid']>0) {var_dump($row);exit(0);} console.log(document.getElementById(\'pageUid\').value);
        // $row['pid'] ? GeneralUtility::quoteJSvalue($row['pid']) :
        if($this->pageUid) {
            $aOnClick = 'return jumpTo(' . GeneralUtility::quoteJSvalue($row['pid'] ?? $this->pageUid) . ',' . GeneralUtility::quoteJSvalue($this->getJumpToParam($row)) . ',this,' . GeneralUtility::quoteJSvalue($this->domIdPrefix . $this->getId($row)) . ',' . $bank . ');';
        } else {
            $aOnClick = 'return jumpTo(' . ('document.getElementById(\'pageUid\').value') . ',' . GeneralUtility::quoteJSvalue($this->getJumpToParam($row)) . ',this,' . GeneralUtility::quoteJSvalue($this->domIdPrefix . $this->getId($row)) . ',' . $bank . ');';
        }
        return '<a href="#" onclick="' . htmlspecialchars($aOnClick) . '">' . $title . '</a>';
    }
    public function getDragDropCode($hlClass)
    {
        return '
            var currentState = ModuleStateStorage.current(\'' .  $this->mainModule . '\');
            Tree.highlightClass = "' . $hlClass . '";
            Tree.highlightActiveItem("", currentState.selection);
        ';
    }
    public function getJumpToScript($cMR)
    {
        return '
        // Function, loading the list frame from navigation tree:
        function jumpTo(pid,uid, linkObj, highlightID, bank) {
            var currentState = ModuleStateStorage.current(\'' .  $this->mainModule . '\');
            var theUrl = top.currentSubScript;
            if (theUrl.indexOf("?") != -1) {
                theUrl += "&id=" + pid
            } else {
                theUrl += "?id=" + pid
            }
                theUrl += "&' . $this->argumentName . '=" + uid
            ModuleStateStorage.update(\'' .  $this->mainModule . '\', \'mount\', bank);
            top.TYPO3.Backend.ContentContainer.setUrl(theUrl);
            ModuleStateStorage.update(\'' .  $this->mainModule . '\', pid +"&' . $this->argumentName . '=" + uid);
            Tree.highlightActiveItem("' . $this->mainModule . '", highlightID + "_" + bank);

            if (linkObj) { linkObj.blur(); }
            return false;
        }
        ';
    }
}
