<?php
declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\Controller;

use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Backend\Template\ModuleTemplateFactory;
use TYPO3\CMS\Core\View\ViewFactoryData;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;


abstract class AbstractBackendTableListController extends ActionController
{

    protected string $tableName = '';
    protected string $entryIdSearchAttribute = 'parent';
    protected string $entryIdArgumentName = 'entryId';
    protected $entryId = 0;
    protected $pageUid = 0;
    protected array $search = [];
    protected string $pageUidArgumentName = 'id';
    protected string $searchArgumentName = 'search';
    protected string $indexTemplate = 'CategoryBackend/Index';

    public function __construct(
                protected readonly ModuleTemplateFactory $moduleTemplateFactory
    ) {}

    public function initializeAction(): void
    {
        $entryIdRaw = $this->request->hasArgument($this->entryIdArgumentName) ? $this->request->getArgument($this->entryIdArgumentName) : $this->request->getQueryParams()[$this->entryIdArgumentName] ?? null;

        // Handle mount point identifiers (e.g., 'm12' -> 0)
        // Mount points represent "all items in this folder", so we don't filter by category
        if (is_string($entryIdRaw) && str_starts_with($entryIdRaw, 'm')) {
            $this->entryId = 0;
        } else {
            $this->entryId = $entryIdRaw;
        }

        $this->pageUid = $this->request->hasArgument($this->pageUidArgumentName) ? $this->request->getArgument($this->pageUidArgumentName) : $this->request->getQueryParams()[$this->pageUidArgumentName] ?? null;
        $this->search = $this->request->hasArgument($this->searchArgumentName) ? $this->request->getArgument($this->searchArgumentName) : [];
    }

    /**
     * Action index
     *
     * @return void
     */
    public function indexAction(): ResponseInterface
    {
        $view = $this->moduleTemplateFactory->create($this->request);

        if(!$this->tableName) {
            die('$this->tableName is not defined in ' . static::class);
        }
        if(!isset($GLOBALS['TCA'][$this->tableName])) {
            die('$this->tableName has value "' . $this->tableName . '", but is not found in TCA. In class ' . static::class);
        }
        /*if(!$this->entryIdSearchAttribute) {
            die('$this->entryIdSearchAttribute is not defined in ' . get_class($this));
        }*/
        //TODO: HERE var_dump($this->request->getArguments());


        $where = [];
        if($this->entryId > 0) {
            $where = [$this->entryIdSearchAttribute => $this->entryId];
        }
        $this->search = array_merge($this->search, $where);

        $view->assign('tableName', $this->tableName);
        $view->assign('entryId', $this->entryId);
        $view->assign('searchArgumentName', $this->searchArgumentName);
        $view->assign('entryIdArgumentName', $this->entryIdArgumentName);
        $view->assign('entryIdSearchAttribute', $this->entryIdSearchAttribute);
        $view->assign('pageUid', $this->pageUid);

        $view->assign('where', $where);
        $view->assign('search', $this->search);
        $returnUrlParameters = [
            $this->searchArgumentName => $this->search,
        ];
        if($this->entryId > 0) {
            $returnUrlParameters[$this->entryIdArgumentName] = $this->entryId;
        }
        $view->assign('returnUrlParameters', $returnUrlParameters);

        // Ausgewählte Kategorie im TCA bei anlegen setzen (Bei Frame tableTree und tableList)
        if ($this->entryId) {
            $defVals = [
                $this->tableName => [
                    $this->entryIdSearchAttribute =>  $this->entryId
                ],
            ];
        } else {
            $defVals = [];
        }
        $view->assign('defVals', $defVals);
        // Reuse the paths from $this->view
        //return $view->render();
        return $view->renderResponse($this->indexTemplate);
    }

}
