<?php

declare(strict_types=1);

namespace Internetgalerie\IgBackendHelpers\View;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Browse pages in Web module
 *
 * @internal This class is a TYPO3 Backend implementation and is not considered part of the Public TYPO3 API.
 */
class PageTreeView extends \TYPO3\CMS\Backend\View\PageTreeView
{
    protected $additionalSqlWhere = 'AND doktype=254';

    /**
     * Calls init functions
     *
     * @param string $clause        Additional clause for selecting pages.
     * @param string $orderByFields record ORDER BY field
     */
    public function __construct(string $clause = '', string $orderByFields = '')
    {
        parent::__construct();
        $this->init($clause, $orderByFields);
    }

    public function setMounts(array $rootUids): void
    {
        $backendUser = $this->getBackendUser();
        // This will hide records from display - it has nothing to do with user rights!!
        $clauseExcludePidList = '';
        $pidList = $backendUser->getTSConfig()['options.']['hideRecords.']['pages'] ?? '';
        if (! empty($pidList)) {
            if ($pidList = implode(',', GeneralUtility::intExplode(',', $pidList))) {
                $clauseExcludePidList = ' AND pages.uid NOT IN (' . $pidList . ')';
            }
        }
        $this->MOUNTS = $rootUids;
        if ($pidList) {
            // Remove mountpoint if explicitly set in options.hideRecords.pages (see above)
            $hideList = explode(',', $pidList);
            $this->MOUNTS = array_diff($this->MOUNTS, $hideList);
        }
    }

    public function setAadditionalSqlWhere(string $additionalSqlWhere): void
    {
        $this->additionalSqlWhere = $additionalSqlWhere;
    }

    /**
     * copy of original getBrowsableTree with the possibility to set the max deep
     * Will create and return the HTML code for a browsable tree
     * Is based on the mounts found in the internal array ->MOUNTS (set in the constructor)
     *
     * @param  int $deep max deep of the tree (0= only moountPoints)
     *
     * @return string HTML code for the browsable tree
     */
    public function getBrowsableTree(int $deep = 999): string
    {

        // Get stored tree structure AND updating it if needed according to incoming PM GET var.
        $this->initializePositionSaving();
        // Init done:
        $treeArr = [];
        // Traverse mounts:
        $firstHtml = '';
        foreach ($this->MOUNTS as $idx => $uid) {
            // Set first:
            $this->bank = $idx;
            $isOpen = $this->stored[$idx][$uid] || $this->expandFirst || $uid === '0';
            // Save ids while resetting everything else.
            $curIds = $this->ids;
            $this->reset();
            $this->ids = $curIds;
            // Only, if not for uid 0
            if ($uid) {
                // Set PM icon for root of mount:
                $cmd = $this->bank . '_' . ($isOpen ? '0_' : '1_') . $uid . '_' . $this->treeName;
                $firstHtml = '<a class="list-tree-control list-tree-control-' . ($isOpen ? 'open' : 'closed')
                    . '" href="' . htmlspecialchars($this->getThisScript() . 'PM=' . $cmd) . '"><i class="fa"></i></a>';
            }
            // Preparing rootRec for the mount
            if ($uid) {
                $rootRec = $this->getRecord($uid);
                $firstHtml .= $this->getIcon($rootRec);
            } else {
                // Artificial record for the tree root, id=0
                $rootRec = $this->getRootRecord();
                $firstHtml .= $this->getRootIcon($rootRec);
            }
            if (is_array($rootRec)) {
                // In case it was swapped inside getRecord due to workspaces.
                $uid = $rootRec['uid'];
                // Add the root of the mount to ->tree
                $this->tree[] = ['HTML' => $firstHtml, 'row' => $rootRec, 'bank' => $this->bank, 'hasSub' => true, 'invertedDepth' => 1000];
                // If the mount is expanded, go down:
                if ($isOpen) {
                    // Set depth:
                    if ($this->addSelfId) {
                        $this->ids[] = $uid;
                    }
                    if ($deep > 0) {
                        $this->getTree($uid, $deep);
                    }
                }
                // Add tree:
                $treeArr = array_merge($treeArr, $this->tree);
            }
        }
        return $this->printTree($treeArr);
    }
}
