<?php

namespace Ig\IgChart\Controller;

use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

/**
 * output chart with data from plugin
 */
class ChartController extends ActionController
{
    /**
     * Display a chart.
     */
    public function showAction(): ResponseInterface
    {
        // Get the colors for the charts
        $colors = [];

        // Override the global colors if neeeded
        if ($this->settings['flexform']['overrideColors']) {
            $colors = $this->settings['flexform']['colors'];
            // We need to 're-index' the array, so it starts at 0 instead of 1
            $colors = array_values($colors);
        } else {
            foreach ($this->settings['colors'] as $color) {
                $colors[] = $color;
            }
        }

        //Get chartData either from file or from directInput
        $chartData = '';
        if (isset($this->settings['flexform']['directInput']) && $this->settings['flexform']['directInput'] == 1) {
            $chartData = $this->settings['flexform']['data'];
        } elseif (!empty($this->settings['flexform']['csvdata'])) {
            $fileRepository = GeneralUtility::makeInstance(FileRepository::class);
            $chartData = $fileRepository->findFileReferenceByUid(
                intval($this->settings['flexform']['csvdata'])
            )->getContents();
            $chartData = utf8_encode((string) $chartData);
        }
        if (str_contains((string) $chartData, ';')) {
            $chartData = str_replace(';', ',', $chartData);
        }
        // Removing spaces at the end of the data
        $this->view->assign('chartData', rtrim((string) $chartData));

        // The first letter of the type needs to be in lowercase for chart.js
        $this->view->assign('chartType', lcfirst((string) $this->settings['flexform']['charttype']));

        $this->view->assign('colors', $colors);
        $this->view->assign('showLegend', $this->settings['flexform']['showLegend']);
        $this->view->assign('disableTooltipData', $this->settings['flexform']['disableTooltipData']);
        $this->view->assign('yScaleSuffix', $this->settings['flexform']['yScaleSuffix']);
        $this->view->assign('xScaleSuffix', $this->settings['flexform']['xScaleSuffix']);
        $this->view->assign('fallbackImg', $this->settings['flexform']['fallbackimg']);
        $this->view->assign('cutoutPercentage', $this->settings['flexform']['cutoutPercentage']);
        $this->view->assign('showDoughnutTotal', $this->settings['flexform']['showDoughnutTotal']);
        $this->view->assign('doughnutTotalSuffix', $this->settings['flexform']['doughnutTotalSuffix']);

        $this->view->assign('ratio', $this->settings['flexform']['ratio']);

        // Scale settings
        $this->view->assign('showXScale', $this->settings['flexform']['showXScale']);
        $this->view->assign('showYScale', $this->settings['flexform']['showYScale']);
        $this->view->assign('xScalePosition', $this->settings['flexform']['xScalePosition']);
        $this->view->assign('yScalePosition', $this->settings['flexform']['yScalePosition']);
        $this->view->assign('yStepSize', $this->settings['flexform']['yStepSize']);
        $this->view->assign('yScaleMax', $this->settings['flexform']['yScaleMax']);
        $this->view->assign('yScaleMin', $this->settings['flexform']['yScaleMin']);
        $this->view->assign('xStepSize', $this->settings['flexform']['xStepSize']);
        $this->view->assign('xScaleMax', $this->settings['flexform']['xScaleMax']);
        $this->view->assign('xScaleMin', $this->settings['flexform']['xScaleMin']);

        // Font settings
        $this->view->assign('scaleFontFamily', $this->settings['flexform']['scaleFontFamily']);
        $this->view->assign('scaleFontColor', $this->settings['flexform']['scaleFontColor']);
        $this->view->assign('scaleFontSize', $this->settings['flexform']['scaleFontSize']);
        $this->view->assign('scaleFontStyle', $this->settings['flexform']['scaleFontStyle']);

        // Get global options
        $this->view->assign('animationDuration', $this->settings['animationDuration']);
        $this->view->assign('animationEasing', $this->settings['animationEasing']);
        return $this->htmlResponse($this->view->render());
    }
}
