<?php

namespace Ig\IgChart\ViewHelpers;

use Ig\IgChart\Domain\Model\Chart;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

abstract class AbstractChartViewHelper extends AbstractTagBasedViewHelper
{
    protected $chartType = null;
    protected ConfigurationManagerInterface $configurationManager;
    protected array $settings = [];

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }

    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();

        $this->registerArgument('chartData', 'midex', 'Char Data', false, null);
        $this->registerArgument('chartRows', 'midex', 'Char Data', false, null);
        $this->registerArgument('dataLimit', 'int', 'data limit', false, null);
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'IgChart'
        );
        $colors = $this->settings['colors'];//?? ['#e0440e', '#e6693e', '#ec8f6e', '#f3b49f', '#f6c7b6'];
        //	var_dump(array_values($colors));exit(0);
        //array('#ABCDEF', '#DEFFAA', ...)
        $this->registerArgument('color', 'string', 'attribute for coloring the data', false);
        $this->registerArgument('colors', 'array', 'colors for dataset e.x. ["#ABCDEF", "DEFABC"]', false, $colors);
        $this->registerArgument('maxColors', 'string', 'Maximale Farben', false, '20');
        $this->registerArgument('showLegend', 'boolean', 'Legende anzeigen', false, '');
        $this->registerArgument('disableTooltipData', 'boolean', 'Tooltip Daten ausblenden', false, '');


        $this->registerArgument('x', 'string', 'X Attribute', false, 'x');
        $this->registerArgument('y', 'midex', 'Y Attribute', false, [
            'y' => 'y',
        ]);


        $this->registerArgument('cutoutPercentage', 'string', 'Donut-Radius', false, 50);
        $this->registerArgument('showDoughnutTotal', 'string', 'Doughnut-Total anzeigen', false, 0);
        $this->registerArgument('doughnutTotalSuffix', 'string', 'Doughnut-Total-Suffix', false, '');


        $this->registerArgument('ratio', 'string', 'Seitenverhältnis', false, '16-9');

        $this->registerArgument('animationDuration', 'string', 'Animationsdauer', false, '1000');
        $this->registerArgument('animationEasing', 'string', 'Animationsfunktion', false, 'easeOutQuad');
        $this->registerArgument('animationDelay', 'integer', 'Animation Verzögerung', false, 0);

        // Scale settings
        $this->registerArgument('showXScale', 'string', 'X-Achse anzeigen', false, '1');
        $this->registerArgument('showYScale', 'string', 'Y-Achse anzeigen', false, '1');

        $this->registerArgument('xScalePosition', 'string', 'Position der X-Achse', false, 'bottom');
        $this->registerArgument('yScalePosition', 'string', 'Position der Y-Achse', false, 'left');
        $this->registerArgument('yScaleSuffix', 'string', 'Y-Achsen Suffix', false, '');
        $this->registerArgument('yStepSize', 'string', 'Schrittgrösse der Y-Achse', false, null);
        $this->registerArgument('yScaleMax', 'string', 'Maximaler Y-Wert', false, null);
        $this->registerArgument('yScaleMin', 'string', 'Minimaler Y-Wert', false, null);
        $this->registerArgument('xScaleSuffix', 'string', 'Y-Achsen Suffix', false, '');
        $this->registerArgument('xStepSize', 'string', 'Schrittgrösse der Y-Achse', false, null);
        $this->registerArgument('xScaleMax', 'string', 'Maximaler Y-Wert', false, null);
        $this->registerArgument('xScaleMin', 'string', 'Minimaler Y-Wert', false, null);
        $this->registerArgument('xReverse', 'bool', 'Reverse the scale of x', false, false);
        $this->registerArgument('yReverse', 'bool', 'Reverse the scale of y', false, false);

        // Font settings
        $this->registerArgument('scaleFontFamily', 'string', 'Schriftart', false, 'Arial, sans-serif');
        $this->registerArgument('scaleFontColor', 'string', 'Schriftfarbe', false, '#666666');
        $this->registerArgument('scaleFontSize', 'string', 'Schriftgrösse', false, '12');
        $this->registerArgument('scaleFontStyle', 'string', 'Schriftstil', false, 'normal');

        $this->registerArgument('additionalOptions', 'array', 'Zusätzliche Optionen', false, []);

        $this->registerArgument('fallbackImg', 'string', 'fallbackImg', false, '');
        $this->registerArgument('locale', 'string', 'locale', false, $this->settings['locale']);
    }




    public function render()
    {
        $chart = GeneralUtility::makeInstance(Chart::class);
        $chart->setType($this->chartType);
        $chart->setColors($this->arguments['colors']);

        if (isset($this->arguments['chartRows']) && is_array($this->arguments['chartRows'])) {
            $chartRows = $this->arguments['chartRows'];
            $dataLimit = (int) $this->arguments['dataLimit'] ?? 0;
            if ($dataLimit > 0) {
                $chartRows = array_slice($chartRows, 0, $dataLimit);
            }
            $chart->setDatasetsAndLabelsFromRecords(
                $chartRows,
                $this->arguments['x'],
                $this->arguments['y'],
                $this->arguments['color'] ?? null
            );
        } else {
            if (is_string($this->arguments['chartData'])) {
                // Generate labels
                // Build correct data format for each chart type.
                $chart->getDatasetsFromCsv($this->arguments['chartData']);
            } else {
                $chart->setDatasetsAndLabels($this->arguments['chartData'], $this->arguments['dataLimit']);
            }
        }

        //$this->setDatasetsAndLabels($chart->getData(), $chart->getLabels());
        return $chart->getHtml($this->arguments);
    }
}
