<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Ig\IgChart\Controller\ChartController;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\BitmapIconProvider;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

defined('TYPO3') or die();

ExtensionUtility::configurePlugin(
	'IgChart',
	'Igchart',
	[
        ChartController::class => 'show',
	],
	// non-cacheable actions
	[
	 ]
);


// Register icon
$iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);
$iconRegistry->registerIcon(
  'chart-icon',
  BitmapIconProvider::class,
  ['source' => 'EXT:ig_chart/Resources/Public/Icons/chart.svg']
);


//Include TypoScript for PageTSConfig
ExtensionManagementUtility::addPageTSConfig(
    "@import 'EXT:ig_chart/Configuration/TypoScript/extTsConfig.tsconfig'"
);
