<?php

namespace Ig\IgChart\ViewHelpers;

use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;

/**
 * View Helper Text
 *
 * @api
 */
abstract class AbstractTableViewHelper extends AbstractTagBasedViewHelper
{
    protected $chartType = null;

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }
    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();

        $this->registerArgument('chartData', 'midex', 'Char Data', false, null);
        $this->registerArgument('chartRows', 'midex', 'Char Data', false, null);
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'igChart',
            'ig_chart'
        );
        $colors = $this->settings['colors'];//?? ['#e0440e', '#e6693e', '#ec8f6e', '#f3b49f', '#f6c7b6'];
        //	var_dump(array_values($colors));exit(0);
        //array('#ABCDEF', '#DEFFAA', ...)
        $this->registerArgument('colors', 'array', 'Farben', false, $colors);
        $this->registerArgument('maxColors', 'string', 'Maximale Farben', false, '20');
        $this->registerArgument('showLegend', 'boolean', 'Legende anzeigen', false, '');
        $this->registerArgument('disableTooltipData', 'boolean', 'Tooltip Daten ausblenden', false, '');


        $this->registerArgument('x', 'string', 'X Attribute', false, 'x');
        $this->registerArgument('y', 'midex', 'Y Attribute', false, [
            'y' => 'y',
        ]);


        $this->registerArgument('cutoutPercentage', 'string', 'Donut-Radius', false, 50);
        $this->registerArgument('showDoughnutTotal', 'string', 'Doughnut-Total anzeigen', false, 0);
        $this->registerArgument('doughnutTotalSuffix', 'string', 'Doughnut-Total-Suffix', false, '');


        $this->registerArgument('ratio', 'string', 'Seitenverhältnis', false, '16-9');

        $this->registerArgument('animationDuration', 'string', 'Animationsdauer', false, '1000');
        $this->registerArgument('animationEasing', 'string', 'Animationsfunktion', false, 'easeOutQuad');

        // Scale settings
        $this->registerArgument('showXScale', 'string', 'X-Achse anzeigen', false, '1');
        $this->registerArgument('showYScale', 'string', 'Y-Achse anzeigen', false, '1');

        $this->registerArgument('xScalePosition', 'string', 'Position der X-Achse', false, 'bottom');
        $this->registerArgument('yScalePosition', 'string', 'Position der Y-Achse', false, 'left');
        $this->registerArgument('yScaleSuffix', 'string', 'Y-Achsen Suffix', false, '');
        $this->registerArgument('yStepSize', 'string', 'Schrittgrösse der Y-Achse', false, null);
        $this->registerArgument('yScaleMax', 'string', 'Maximaler Y-Wert', false, null);
        $this->registerArgument('yScaleMin', 'string', 'Minimaler Y-Wert', false, null);
        $this->registerArgument('xScaleSuffix', 'string', 'Y-Achsen Suffix', false, '');
        $this->registerArgument('xStepSize', 'string', 'Schrittgrösse der Y-Achse', false, null);
        $this->registerArgument('xScaleMax', 'string', 'Maximaler Y-Wert', false, null);
        $this->registerArgument('xScaleMin', 'string', 'Minimaler Y-Wert', false, null);

        // Font settings
        $this->registerArgument('scaleFontFamily', 'string', 'Schriftart', false, 'Arial, sans-serif');
        $this->registerArgument('scaleFontColor', 'string', 'Schriftfarbe', false, '#666666');
        $this->registerArgument('scaleFontSize', 'string', 'Schriftgrösse', false, '12');
        $this->registerArgument('scaleFontStyle', 'string', 'Schriftstil', false, 'normal');

        $this->registerArgument('fallbackImg', 'string', 'fallbackImg', false, '');
        $this->registerArgument('locale', 'string', 'locale', false, $this->settings['locale']);
    }




    public function render()
    {
        $html = '<table class="stat-table-legend">';
        if (is_string($this->arguments['chartData'])) {
        }
        $y = $this->arguments['y'];
        $x = $this->arguments['x'];
        $dataRecords = $this->arguments['chartRows'];
        if (is_array($y)) {
            foreach ($dataRecords as $nr => $data) {
                $html .= '<tr>';
                $html .= '<td class="stat-legend-label">' . htmlspecialchars((string) $data[$x]) . '</td>';
                foreach ($y as $label => $attribute) {
                    $html .= '<td class="stat-legend-value">' . (float)$data[$attribute] . '</td>';
                }
                $html .= '</tr>';
            }
        } else {
            // y ist nur ein Attributename
            foreach ($dataRecords as $nr => $data) {
                $html .= '<tr>';
                $html .= '<td class="stat-legend-label">' . htmlspecialchars((string) $data[$x]) . '</td>';
                $html .= '<td class="stat-legend-value">' . htmlspecialchars((string) $data[$y]) . '</td>';
                $html .= '</tr>';
            }
        }

        /*
          foreach( $this->arguments['chartData'] as $label=>$data) {
          $html.='<tr>';
          $html.='<td>' . htmlspecialchars($label) . '</td>';
          foreach($data as $key=>$d) {
          $html .= '<td>' . htmlspecialchars($d) . '</td>';
          }
          $html.='</tr>';
          }
        */
        $html .= '</table>';
        return $html;
        /*
        $chart = GeneralUtility::makeInstance(\Ig\IgChart\Domain\Model\Chart::class);
        $chart->setType( $this->chartType );
        $chart->setColors( $this->arguments['colors'] );
        if( isset($this->arguments['chartRows']) && is_array($this->arguments['chartRows']) ) {
            $chart->setDatasetsAndLabelsFromRecords($this->arguments['chartRows'], $this->arguments['x'], $this->arguments['y']);
        } else {
            if( is_string($this->arguments['chartData']) ) {
                // Generate labels
                // Build correct data format for each chart type.
                $chart->getDatasetsFromCsv($this->arguments['chartData']);
            } else {
                $chart->setDatasetsAndLabels($this->arguments['chartData']);
            }
        }
        //$this->setDatasetsAndLabels($chart->getData(), $chart->getLabels());
        return $chart->getHtml( $this->arguments );
        */
    }
}
