<?php
namespace Ig\IgContainergallery\Controller;

use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Resource\Index\MetaDataRepository;
use TYPO3\CMS\Core\Resource\ResourceFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ContainergalleryController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * fileRepository.
     *
     * @var \TYPO3\CMS\Core\Resource\FileRepository
     */
    protected $fileRepository = null;

    protected ResourceFactory $resourceFactory;

    /**
     * metaDataRepository .
     *
     * @var \TYPO3\CMS\Core\Resource\Index\MetaDataRepository
     */
    protected $metaDataRepository = null;

    /**
     * The image ratio for the slider.
     *
     * @var float
     */
    private $sliderRatio = 1.0;

    public function __construct(FileRepository $fileRepository, MetaDataRepository $metaDataRepository, ResourceFactory $resourceFactory)
    {
        $this->fileRepository = $fileRepository;
        $this->metaDataRepository = $metaDataRepository;
        $this->resourceFactory = $resourceFactory;
    }

    public function initializeAction(): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addCssFile('EXT:ig_containergallery/Resources/Public/Css/ig_containergallery.scss');
        $pageRenderer->addJsFile('EXT:ig_containergallery/Resources/Public/JavaScript/ig_gridgallery.js');
    }

    /**
     * Displays a gallery.
     *
     * @return void
     */
    public function showAction(): ResponseInterface
    {
        $flexForm = $this->settings['flexform'];
        $imagesUidArray = array_filter(explode(',', $flexForm['images']));
        $uid = $this->request->getAttribute('currentContentObject')->data['uid'];
        $fileRepository = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Resource\\FileRepository');
        $fileObjects = $fileRepository->findByRelation('tt_content', 'settings.flexform.images', $uid);
        $fileObjects2 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer2', $uid);
        $fileObjects3 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer3', $uid);
        // $fileObjects4 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer4', $uid);
        $fileObjects4 = GeneralUtility::trimExplode(',', $flexForm['layer4']);

        $layer2 = null;
        $layer3 = null;
        $layer4 = null;
        $orientation = [];
        $orientationLayer2 = [];
        $orientationLayer3 = [];
        $orientationLayer4 = [];

        $multiLayer = 0;
        if(!empty($fileObjects2) || !empty($fileObjects3) || !empty($fileObjects4)){
            $multiLayer = 1;
        }

        // Get the image ratio as a float number
        if ($flexForm['aspectRatio'] != 'spezial') {
            $ratio = explode('-', str_replace('aspect', '', $flexForm['aspectRatio']));
            if ($ratio[0]) {
                $this->sliderRatio = $ratio[1] / $ratio[0];
            } else {
                $ratio = 0;
            }
        }

        //$pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        //$pageRenderer->addJsFooterLibrary( 'slickThumbs', 'EXT:ig_render/Resources/Public/slick/thumbs.js');
        $pageRenderer = GeneralUtility::makeInstance(\Internetgalerie\IgRender\Utility\PageRendererUtility::class);
        $pageRenderer->reset();
        /**
         * We check the 'orientation' of the images. This is needed so we can later
         * define which images should have a width, or a height of 100% so they can
         * fill the container.
         */
        $images = $fileObjects;
        if(!empty($fileObjects2)) {
            $layer2 = $fileObjects2;
        }

        /*if ($fileObjects2) {
            $orientationLayer2 = $this->getImageOrientation($layer2Uids);
        }*/

        if(!empty($fileObjects3)) {
            $layer3 = $fileObjects3;
        }

        /*if ($layer3) {
            $orientationLayer3 = $this->getImageOrientation($layer3Uids);
        }*/

        if (!empty($fileObjects4)) {
            $layer4 = $fileObjects4;
        }

        /*if ($layer4) {
            $orientationLayer4 = $this->getImageOrientation($layer4Uids);
        }*/

        $galleryClasses = ['ig-containergallery'];

        $animationClass = ($flexForm['useHover'] ?? null) ? 'item-animation' : 'item-noanimation';
        $borderClass = ($flexForm['useBorder'] ?? null) ? 'hasBorder' : '';

        if ($flexForm['usePreloader']) {
            array_push($galleryClasses, 'has-preloader');
        }

        if (!$flexForm['hideContent']) {
            array_push($galleryClasses, 'has-thumbs');
        }

        $this->view->assignMultiple([
            'galleryId' => 'gallery-' . uniqid(),
            'galleryClasses' => implode(' ', $galleryClasses),

            // General
            'cols' => $flexForm['cols'],
            'displayStyle' => $flexForm['displayStyle'],
            'thumbRatio' => $flexForm['thumbRatio'],
            'thumbDesign' => $flexForm['thumbDesign'],
            'images' => $images,
            'orientation' => $orientation,
            'orientationLayer2' => $orientationLayer2,
            'orientationLayer3' => $orientationLayer3,
            'orientationLayer4' => $orientationLayer4,

            // Lightbox
            'useLightbox' => intval($flexForm['useLightbox']),
            'useSliderLightbox' => intval($flexForm['useSliderLightbox']),

            // Slider
            'useSlider' => intval($flexForm['slider']),
            'thumbnailMoveSlider' => intval($flexForm['thumbnailMoveSlider']),
            'transitionStyle' => $flexForm['transitionStyle'],
            'aspectRatio' => $flexForm['aspectRatio'],
            'renderMode' => $flexForm['renderMode'],
            'slideshowtime' => intval($flexForm['slideshowtime']),
            'animationtime' => intval($flexForm['animationtime']),
            'useSlideshow' => intval($flexForm['useSlideshow']),

            // Multilayer Slider
            'multiLayer' => $multiLayer,
            'layer2' => $layer2,
            'layer2Animationtime' => $flexForm['layer2Animationtime'],
            'layer3' => $layer3,
            'layer3Animationtime' => $flexForm['layer3Animationtime'],
            'layer4' => $layer4,
            'layer4Animationtime' => $flexForm['layer4Animationtime'],

            // Extra
            'hideContent' => intval($flexForm['hideContent']),
            'showNav' => intval($flexForm['showNav']),
            'usePreloader' => intval($flexForm['usePreloader']),
            'animationClass' => $animationClass,
            'hasBorder' => $borderClass,
            'useDarkIcons' => intval($flexForm['useDarkIcons'] ?? null),
        ]);

        // Use the entire flexform as cache identifier so configuration changes update the cache.
        $cacheIdentifier = sha1(json_encode($flexForm));

        $cacheManager = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class);
        $cache = $cacheManager->getCache('ig_containergallery');

        // try to find the cached content
        if (($contentAssets = $cache->get($cacheIdentifier)) === false) { // no cache content
            if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('ig_responsive_images')) {
                $responsiveImageUtility = GeneralUtility::makeInstance(\Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility::class);
                //echo('width='.$row['width'] .','.$igFlow->getLineWidth() .'='.round($row['width']/$igFlow->getLineWidth()*100,1) );
                //$colWidth=intval(substr($flexForm['cols'],4));
                //$responsiveImageUtility->pushClass( 'igContainergallery-'. round(100/$colWidth) ); // ym-gXXX
                $responsiveImageUtility->pushClass('igContainergallery-' . $flexForm['displayStyle'] . '-' . $flexForm['cols']); // ym-gXXX
                $content = $this->view->render();
                $responsiveImageUtility->popClass();
            } else {
                $content = $this->view->render();
            }
            
            // sind tags uebhaupt sinnvoll?
            $contentObj = $this->request->getAttribute('currentContentObject');
            $assets = $pageRenderer->getAssets();
            $contentAssets = ['content' => $content, 'assets' => $assets];
            $cache->set($cacheIdentifier, $contentAssets, ['page_' . $GLOBALS['TSFE']->id, 'element_' . $contentObj->data['uid']]);
        } else {
            $pageRenderer->addAssets($contentAssets['assets']);
        }

        return $this->htmlResponse($contentAssets['content']);
    }

    /**
     * Displays a gallery.
     *
     * @return void
     */
    public function gridAction()
    {
        $flexForm = $this->settings['flexform'];
        $uid = $this->request->getAttribute('currentContentObject')->data['uid'];
        $fileRepository = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Resource\\FileRepository');
        $fileObjects = $fileRepository->findByRelation('tt_content', 'settings.flexform.images', $uid);
        $fileObjects2 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer2', $uid);
        $fileObjects3 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer3', $uid);
        $fileObjects4 = $fileRepository->findByRelation('tt_content', 'settings.flexform.layer4', $uid);
        $orientation = [];
        $orientationLayer2 = [];
        $orientationLayer3 = [];
        $orientationLayer4 = [];
        $ratio = 0;
        $layer1 = null;
        $layer2 = null;
        $layer3 = null;
        $layer4 = null;

        $multiLayer = 0;
        if(!empty($fileObjects2) || !empty($fileObjects3) || !empty($fileObjects4)){
            $multiLayer = 1;
        }

        // Get the image ratio as a float number
        if (isset($flexForm['aspectRatio']) && $flexForm['aspectRatio'] != 'aspect-spezial') {
            $ratio = explode('-', str_replace('aspect', '', $flexForm['aspectRatio']));
            if ($ratio[0] != 0) {
                $this->sliderRatio = $ratio[1] / $ratio[0];
            } else {
                $ratio = 0;
            }
        }

        //$pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        //$pageRenderer->addJsFooterLibrary( 'slickThumbs', 'EXT:ig_render/Resources/Public/slick/thumbs.js');
        $pageRenderer = GeneralUtility::makeInstance(\Internetgalerie\IgRender\Utility\PageRendererUtility::class);
        $pageRenderer->reset();
        /**
         * We check the 'orientation' of the images. This is needed so we can later
         * define which images should have a width, or a height of 100% so they can
         * fill the container.
         */
        $images = $fileObjects;
        if (!empty($fileObjects2)) {
            $layer2 = $fileObjects2;
        }

        /*if ($fileObjects2) {
            $orientationLayer2 = $this->getImageOrientation($layer2Uids);
        }*/

        if (!empty($fileObjects3)) {
            $layer3 = $fileObjects3;
        }

        /*if ($layer3) {
            $orientationLayer3 = $this->getImageOrientation($layer3Uids);
        }*/

        if (!empty($fileObjects4)) {
            $layer4 = $fileObjects4;
        }

        /*if ($layer4) {
            $orientationLayer4 = $this->getImageOrientation($layer4Uids);
        }*/

        $galleryClasses = ['ig-containergallery'];

        // ugly fix because flexform is mostly deleted
        $animationClass = 'item-animation';
        $negativeSpacing = null;
        $customSpacing = null;
        if($flexForm['useSpacing'] ?? null){
            $useSpacing = 'useSpacing';
            if($flexForm['customSpacing'] ?? null){
                $customSpacing = $flexForm['customSpacing'];
                $negativeSpacing = "-".implode(' -',explode(' ',$flexForm['customSpacing']));
            }
        }

        if ($flexForm['usePreloader'] ?? null) {
            array_push($galleryClasses, 'has-preloader');
        }

        if (!$flexForm['hideContent'] ?? null) {
            array_push($galleryClasses, 'has-thumbs');
        }
        $this->view->assignMultiple([
            'galleryId' => 'gallery-' . uniqid(),
            'galleryClasses' => implode(' ', $galleryClasses),

            // General
            'cols' => $flexForm['cols'],
            'displayStyle' => $flexForm['displayStyle'],
            'thumbRatio' => $flexForm['thumbRatio'],
            'images' => $images,
            'orientation' => $orientation,
            'orientationLayer2' => $orientationLayer2,
            'orientationLayer3' => $orientationLayer3,
            'orientationLayer4' => $orientationLayer4,

            // Lightbox
            'useLightbox' => intval($flexForm['useLightbox']),
            'useSliderLightbox' => intval($flexForm['useSliderLightbox']),

            // Slider
            'useSlider' => intval($flexForm['slider']),
            'thumbnailMoveSlider' => intval($flexForm['thumbnailMoveSlider']),
            'transitionStyle' => $flexForm['transitionStyle'],
            'aspectRatio' => $flexForm['aspectRatio'],
            'renderMode' => $flexForm['renderMode'],
            'slideshowtime' => intval($flexForm['slideshowtime']),
            'animationtime' => intval($flexForm['animationtime']),
            'useSlideshow' => intval($flexForm['useSlideshow']),

            // Multilayer Slider
            'multiLayer' => $multiLayer,
            'layer2' => $layer2,
            'layer2Animationtime' => $flexForm['layer2Animationtime'],
            'layer3' => $layer3,
            'layer3Animationtime' => $flexForm['layer3Animationtime'],
            'layer4' => $layer4,
            'layer4Animationtime' => $flexForm['layer4Animationtime'],

            // Extra
            'hideContent' => intval($flexForm['hideContent']),
            'showNav' => intval($flexForm['showNav']),
            'usePreloader' => intval($flexForm['usePreloader']),
            'animationClass' => $animationClass,
            'useSpacing' => $useSpacing,
            'customSpacing' => $customSpacing,
            'negativeSpacing' => $negativeSpacing,
            'useDarkIcons' => intval($flexForm['useDarkIcons']),
        ]);

        // Use the entire flexform as cache identifier so configuration changes update the cache.
        $cacheIdentifier = sha1(json_encode($flexForm));

        $cacheManager = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Cache\CacheManager::class);
        $cache = $cacheManager->getCache('ig_containergallery');

        // try to find the cached content
        if (($contentAssets = $cache->get($cacheIdentifier)) === false) { // no cache content
            if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('ig_responsive_images')) {
                $responsiveImageUtility = GeneralUtility::makeInstance(\Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility::class);
                //echo('width='.$row['width'] .','.$igFlow->getLineWidth() .'='.round($row['width']/$igFlow->getLineWidth()*100,1) );
                //$colWidth=intval(substr($flexForm['cols'],4));
                //$responsiveImageUtility->pushClass( 'igContainergallery-'. round(100/$colWidth) ); // ym-gXXX
                $responsiveImageUtility->pushClass('igContainergallery-' . $flexForm['displayStyle'] . '-' . $flexForm['cols']); // ym-gXXX
                $content = $this->view->render();
                $responsiveImageUtility->popClass();
            } else {
                $content = $this->view->render();
            }
            // sind tags uebhaupt sinnvoll?
            $contentObj = $this->request->getAttribute('currentContentObject');;
            $assets = $pageRenderer->getAssets();
            $contentAssets = ['content' => $content, 'assets' => $assets];
            $cache->set($cacheIdentifier, $contentAssets, ['page_' . $GLOBALS['TSFE']->id, 'element_' . $contentObj->data['uid']]);
        } else {
            $pageRenderer->addAssets($contentAssets['assets']);
        }

        return $contentAssets['content'];
    }

    /**
     * Returns the orientation classes (fill-width or fill-height) of the given
     * images.
     *
     * @param array $images
     * @return array
     */
    public function getImageOrientation(array $images)
    {
        $orientations = [];

        foreach ($images as $image) {
            $imageFile = $this->resourceFactory->getFileReferenceObject($image);
            $metaData = $this->metaDataRepository->findByFile($imageFile->getOriginalFile());
            if ($metaData['height'] > $metaData['width'] * $this->sliderRatio) {
                array_push($orientations, 'fill-height');
            } else {
                array_push($orientations, 'fill-width');
            }
        }

        return $orientations;
    }


    /**
     * @todo merge with funciton getImageOrientation above
     * Returns images
     *
     * @param array $imagesUidArray
     * @return array
     */
    public function getImages(array $imagesUidArray)
    {
        $images = [];
        $orientations = [];
        foreach ($imagesUidArray as $image) {
            try {
                $file = $this->resourceFactory->getFileReferenceObject(intval($image));
                $images[] = $file;
                $meta = $this->metaDataRepository->findByFile($file->getOriginalFile());
                if ($meta['height'] > $meta['width'] * $this->sliderRatio) {
                    array_push($orientations, 'fill-height');
                } else {
                    array_push($orientations, 'fill-width');
                }
            } catch (\Exception $e) {
                // Do nothing
            }
        }

        return $images;
    }
}
