<?php

namespace Internetgalerie\IgCookies\ViewHelpers\Services;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ReplacesViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    protected static ?ConfigurationManagerInterface $configurationManager = null;
    protected static ?array $settings = null;

    /**
     * Returns instance of the configuration manager
     */
    protected static function getConfigurationManager(): ConfigurationManagerInterface
    {
        if (null !== static::$configurationManager) {
            return static::$configurationManager;
        }
        if (VersionNumberUtility::convertVersionNumberToInteger(VersionNumberUtility::getNumericTypo3Version()) >= 11000000) {
            static::$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        } else {
            $objectManager = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Object\ObjectManager::class);
            static::$configurationManager = $objectManager->get(ConfigurationManagerInterface::class);
        }
        return static::$configurationManager;
    }

    protected static function getSettings(): array
    {
        if (static::$settings === null) {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );
            static::$settings = $all['plugin.']['tx_igcookies.']['settings.'] ?? [];
        }
        return static::$settings;
    }


    public function render(): string
    {
        $arguments = $this->arguments;
        
        $content = $this->renderChildren();

        static::getSettings();
        $services = static::$settings['services.'];
        $replaces = [];
        foreach ($services as $consent => $service) {
            $consent =  trim($consent, '.');
            if (isset($service['replaces.'])) {
                foreach ($service['replaces.'] as $replace) {
                    if (!isset($replaces[$consent])) {
                        $replaces[$consent] = [];
                    }
                    foreach ($replace as $attribute => $value) {
                        $replaces[] = [
                            'search' => ' ' . $attribute . '="' . $value,
                            'replace' => ' data-consent="' . $consent . '" data-' . $attribute . '="' . $value,
                        ];
                    }
                }
            }
        }
        foreach ($replaces as $conf) {
            $content = str_replace($conf['search'], $conf['replace'], $content);
        }
        return $content;
    }
}
