class IgConsentUi {
    constructor() {
        this.manager = window.IgConsentManager;
        this.consentHideStorageName = 'IgConsentManager_hide';
        this.manager.watch(this);
        this.elements = new Map();
        this.setElements();
        this.setButtons();
        this.isDisplayed();
        this.svgArrow = '<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 16 16" width="25px" height="25px"><g fill="currentColor"><path d="m4.464 6.05-.707.707L8 11l4.243-4.243-.707-.707L8 9.586z"/></g></svg>';
        this.svgSwitchOnOff = '<svg class="svg-switch-on-off" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 35 20" width="35px" height="20px"><rect y="0" width="35" height="20" rx="10" ry="10" class="rect" style="stroke-width:0px;"/><circle cx="25" cy="10" r="6" style="fill:#fff; stroke-width:0px;"/><path class="on" d="m15.02,6.47l-.07-.07c-.37-.37-.98-.37-1.35,0l-4.98,4.98-2.97-2.97c-.31-.31-.82-.31-1.13,0l-.29.29c-.31.31-.31.82,0,1.13l3.65,3.65.07.07.11.11c.31.31.82.31,1.13,0l.29-.29s0,0,0,0l5.55-5.55c.37-.37.37-.98,0-1.35Z" style="fill:#fff; stroke-width:0px;"/><path class="off" d="m25.26,10l3.15-3.15c.37-.37.37-.98,0-1.35l-.07-.07c-.37-.37-.98-.37-1.35,0l-3.15,3.15-3.15-3.15c-.37-.37-.98-.37-1.35,0l-.07.07c-.37.37-.37.98,0,1.35l3.15,3.15-3.15,3.15c-.37.37-.37.98,0,1.35l.07.07c.37.37.98.37,1.35,0l3.15-3.15,3.15,3.15c.37.37.98.37,1.35,0l.07-.07c.37-.37.37-.98,0-1.35l-3.15-3.15Z" style="fill:#fff; stroke-width:0px;"/></svg>';
    }

    getTemplate() {
        const Template = ({
            purpose,
            parent,
            serviceHtml,
            translate,
            accordionState,
            active
        }) =>
            `
            <div class="${!parent ? 'purpose' : ''}">
                <div id="service-${purpose.name}" class="service-${purpose.name} cookieCategory checkbox-container">
                    <div class="${!parent ? 'purpose-header ' : ''}checkbox-headline flex ${accordionState}"><!--  add is-open class to auto open accordion -->
                        <div class="flex${!parent ? ' headline-click' : ''}">
                            ${!parent ? '<div class="flex arrow">' + this.svgArrow + '</div>' : ''}
                            <div class="checkbox-header">
                                <span class="cm-list-title">${purpose.title}</span>
                                ${purpose.required ? '<span class="cm-required">(' + translate['alwaysRequired'] + ')</span>' : ''}
                            </div>
                        </div>
                        <label for="service-check-${purpose.name}">
                            <input type="checkbox" id="service-check-${purpose.name}" name="cookieCategories" value="${purpose.name}" ${parent ? 'data-parent="' + parent + '"' : ''} ${purpose.required ? 'disabled="1"' : ''} ${purpose.required ? 'checked="1"' : ''} />
                            <div class="checkbox-slider"${purpose.required ? ' data-disabled="1"' : ''}>${this.svgSwitchOnOff}</div>
                        </label>
                    </div>
                    <div class="checkbox-content">
                        ${purpose.description ? `<p class="cm-list-description">${purpose.description}</p>` : ''}
                        ${serviceHtml ?? ''}
                    </div>
                </div>
            </div>
        `;
        let html = '';
        let usedPurposes = this.manager.getUsedPurposes();
        let accordionState = this.elements.get('outer-container')?.dataset?.accordionState || '';
        for (const purpose of usedPurposes) {
            let purposeActive = true;
            html += '<div class="purpose-group">';
            let serviceHtml = '';
            if (!purpose.hideServices) {
                for (const service of this.manager.services) {
                    const active = this.manager.getConsent(service.name);
                    if (service.purpose == purpose.name && (!service.contextualConsentOnly || active)) {
                        serviceHtml += '<div class="service">' + Template({ purpose: service, parent: service.purpose, translate: this.manager.translations, active: active }) + '</div>';
                        if (!active) {
                            purposeActive = false;
                        }
                    }
                }
            }
            html += Template({ purpose: purpose, parent: '', serviceHtml: serviceHtml, translate: this.manager.translations, accordionState: accordionState, active: purposeActive });

            html += '</div>';
        }
        return html;
    }
    isDisplayed() {
        if (!localStorage.getItem(this.consentHideStorageName)) {
            this.elements.get('html').classList.add('ig-consent-show');
        }
    }
    show() {
        this.elements.get('html').classList.add('ig-consent-show');
    }
    showSettings() {
        this.elements.get('html').classList.add('ig-consent-show');
        this.settings();
    }
    hideAndSave() {
        this.manager.saveAndApplyConsents();
        localStorage.setItem(this.consentHideStorageName, true);
        this.hide();
    }
    hide() {
        this.elements.get('html').classList.remove('ig-consent-show');
    }
    setElements() {
        this.elements.set('html', document.querySelector('html'));
        this.elements.set('outer-container', document.querySelector('.ig-consent-container'));
        this.elements.set('inner-container', document.querySelector('.ig-consent-container-inner'));
        this.elements.set('settings-container-list', document.querySelector('.settings-container-list'));

    }
    setButtons() {
        document.querySelectorAll('.ig-consent-button-save')?.forEach((el, i) => {
            el.addEventListener('click', (e) => {
                e.preventDefault();
                this.save()
            })
        });
        document.querySelectorAll('.ig-consent-button-all')?.forEach((el, i) => {
            el.addEventListener('click', (e) => {
                e.preventDefault();
                this.all()
            })
        });
        document.querySelectorAll('.ig-consent-button-needed')?.forEach((el, i) => {
            el.addEventListener('click', (e) => {
                e.preventDefault();
                this.needed()
            })
        });
        document.querySelectorAll('.ig-consent-button-settings')?.forEach((el, i) => {
            el.addEventListener('click', (e) => {
                e.preventDefault();
                this.settings();
            })
        });
        document.querySelectorAll('.ig-consent-button-close')?.forEach((el, i) => {
            el.addEventListener('click', (e) => {
                e.preventDefault();
                if (this.manager.confirmed) {
                    this.hide();
                } else {
                    this.close();
                }
            })
        });
    }
    update(consents) {
        this.updateServiceBoxes();
    }

    updatePurposeBoxes() {
        // check if all checkboxes of a purpuse are checked
        let allChecked = [];
        this.elements.get('checkboxes-service').forEach(checkbox => {
            if (checkbox.dataset.parent) {
                let purpose = checkbox.dataset.parent;
                if (typeof allChecked[purpose] === 'undefined' || allChecked[purpose]) {
                    allChecked[purpose] = checkbox.checked;
                }
            }
        });

        this.elements.get('checkboxes-purpose').forEach(checkbox => {
            let consent = checkbox.value;
            if (allChecked[consent]) {
                checkbox.checked = true;
            } else {
                checkbox.checked = false;
            }
        });
    }
    setServicesByPurpose(parent, value) {
        this.elements.get('checkboxes-service').forEach(checkbox => {
            if (checkbox.dataset.parent == parent) {
                if (checkbox.checked != value) {
                    this.manager.updateConsent(checkbox.value, value);
                }
                checkbox.checked = value;
            }
        });
    }

    // update services from consent manager
    updateServiceBoxes() {
        let checkboxes = this.elements.get('checkboxes-service');
        if (typeof checkboxes == 'undefined') {
            return;
        }
        checkboxes.forEach(checkbox => {
            let consent = checkbox.value;
            if (this.manager.getConsent(consent)) {
                checkbox.checked = true;
            } else {
                checkbox.checked = false;
            }
        });

        this.updatePurposeBoxes();
    }
    save() {
        this.elements.get('checkboxes-service').forEach(checkbox => {
            if (checkbox.checked) {
                this.manager.updateConsent(checkbox.value, true);
            } else {
                this.manager.updateConsent(checkbox.value, false);
            }
        });
        this.hideAndSave();
    }
    close() {
        this.elements.get('inner-container').classList.remove('settings-show');
    }
    needed() {
        this.manager.changeAll(false);
        this.hideAndSave();
    }
    all() {
        this.manager.changeAll(true);
        this.hideAndSave();
    }
    settings() {
        let settingsContainer = this.elements.get('settings-container-list');
        let content = this.getTemplate();
        if (!settingsContainer.innerHTML) {
            settingsContainer.innerHTML = content;
            this.elements.set('checkboxes-purpose', document.querySelectorAll('.ig-consent-container-inner .purpose .purpose-header input[type="checkbox"]:not(:disabled)'));
            this.elements.set('checkboxes-service', document.querySelectorAll('.ig-consent-container-inner .service input[type="checkbox"]:not(:disabled)'));
            this.elements.set('checkboxes-header', document.querySelectorAll('.ig-consent-container-inner .purpose .purpose-header.checkbox-headline .headline-click'));
            // add checkbox click events
            this.elements.get('checkboxes-purpose').forEach((checkbox) => {
                checkbox.addEventListener('click', () => {
                    this.setServicesByPurpose(checkbox.value, checkbox.checked);
                });
            });
            this.elements.get('checkboxes-service').forEach((checkbox) => {
                checkbox.addEventListener('click', () => {
                    this.manager.updateConsent(checkbox.value, checkbox.checked);
                    this.updatePurposeBoxes();
                    //this.updateServiceBoxes();
                });
            });
            // accordion
            this.elements.get('checkboxes-header').forEach((header) => {
                header.addEventListener('click', () => {
                    header.closest('.checkbox-headline').classList.toggle('is-open');
                });
            });
        }
        this.updateServiceBoxes();
        this.elements.get('inner-container').classList.add('settings-show');
        this.manager.dispatch('onShowSetting', { ui: this });
    }
}

const igConsentUi = new IgConsentUi();
if (typeof window.igJs !== 'undefined') {
    window.igJs.add('igConsentUi', igConsentUi);
}


// cookie settings link for menus
var cookieSettings = document.querySelectorAll('[href="#cookie-settings"]');
// fallback v10
if (cookieSettings === null || !cookieSettings) {
    cookieSettings = document.querySelectorAll('[href="' + window.location.origin + '/#cookie-settings"]');
}
[...cookieSettings].map(function(cookieSetting) {
    cookieSetting.addEventListener('click', (e) => {
        e.preventDefault();
        igConsentUi.showSettings();
    });
});
