<?php

namespace Internetgalerie\IgCookies\Utility;

use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Core\Localization\LanguageServiceFactory;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class ConfigUtility
{
    protected static $languageFile = 'LLL:EXT:ig_cookies/Resources/Private/Language/locallang.xlf';
    protected static $settings = null;
    protected static $configurationManager = null;
    /*
    protected static ?array $settings = null;
    protected static ?ConfigurationManagerInterface $configurationManager = null;
    protected static $labelKeys = ['title', 'description'];
    
    public function getTranslatedLabels($purpose, &$arr)
    {
        foreach (static::$labelKeys as $label) {
            if ($purpose[$label]) {
                $ll = trim($purpose[$label]);
                if (substr($ll, 0, 8) == 'LLL:EXT:') {
                    $arr[$label] = LocalizationUtility::translate($ll) ?? '';
                } else if (strpos($ll, '.') && !strpos($ll, ' ')) {
                    $arr[$label] = LocalizationUtility::translate($this->languageFile . ':' . $ll) ?? '';
                } else {
                    $arr[$label] = $ll;
                }
            }
        }
    }
    */
    public static function isActive(): bool
    {
        return static::getSettings()['active'] ?? false;
    }


    public static function translateArray(&$arr)
    {
        foreach ($arr as $name => &$value) {
            if (is_array($value)) {
                static::translateArray($value);
            } elseif ($value) {
                $ll = trim($value);
                if (substr($ll, 0, 8) == 'LLL:EXT:') {
                    $value = LocalizationUtility::translate($ll) ?? '';
                }
            }
        }
    }

    public static function getPurposesServices($settings): array
    {
        $ret = [
            'purposes' => [],
            'services' => [],
        ];
        $activePurposes = [];

        $purposes = array_filter($settings['purposes']);  //all purposes
        $services = array_filter($settings['services']);

        if ($settings['languageFile'] ?? false) {
            static::$languageFile = $settings['languageFile'];
        }

        // get services
        foreach ($services as $name => &$service) {
            $service['hidden'] = filter_var($service['hidden'] ?? '', FILTER_VALIDATE_BOOLEAN);
            if ($service['hidden']) {
                continue;
            }
            $service['contextualConsentOnly'] = filter_var($service['contextualConsentOnly'] ?? '', FILTER_VALIDATE_BOOLEAN);
            $service['default'] = filter_var($service['default'] ?? '', FILTER_VALIDATE_BOOLEAN);
            $service['required'] = filter_var($service['required'] ?? '', FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);

            static::translateArray($service);
            if (!isset($service['policyText'])) {
                $service['policyText'] = LocalizationUtility::translate(static::$languageFile . ':serviceContextualButton.moreText') ?? '';
            }
            if (!isset($service['sorting'])) {
                $service['sorting'] = 0;
            }
            $service['name'] = $name;
            $ret['services'][] = $service;
            $purposeName = $service['purpose'];
            if (!isset($activePurposes[$purposeName]) && isset($purposes[$purposeName])) {
                $activePurposes[$purposeName] = true;
            }
        }
        usort($ret['services'], function ($a, $b) {
            return $a['sorting'] - $b['sorting'];
        });

        // prepare active/used purposes
        foreach ($purposes as $name => $purpose) {
            if (isset($activePurposes[$name])) {
                $purpose['name'] = $name;
                if (!isset($purpose['sorting'])) {
                    $purpose['sorting'] = 0;
                }
                $purpose['required'] = filter_var($purpose['required'] ?? '', FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
                if ($purpose['required']) {
                    $purpose['default'] = true;
                } else {
                    $purpose['default'] = filter_var($purpose['default'] ?? '', FILTER_VALIDATE_BOOLEAN);
                }

                static::translateArray($purpose);
                $ret['purposes'][] = $purpose;
            }
        }
        usort($ret['purposes'], function ($a, $b) {
            return $a['sorting'] - $b['sorting'];
        });

        // translations
        $ret['translations'] = [
            'alwaysRequired' => LocalizationUtility::translate('LLL:EXT:ig_cookies/Resources/Private/Language/locallang.xlf:always-required'),
            'alwaysUnlockBefore' => LocalizationUtility::translate('LLL:EXT:ig_cookies/Resources/Private/Language/locallang.xlf:always-unlock.before'),
            'alwaysUnlockAfter' => LocalizationUtility::translate('LLL:EXT:ig_cookies/Resources/Private/Language/locallang.xlf:always-unlock.after'),
        ];
        $config = array_filter($settings['config']);
        static::translateArray($config);
        $ret['config'] = $config;
        return $ret;
    }

    protected static function getConfigurationManager(): ConfigurationManagerInterface
    {
        if (null !== static::$configurationManager) {
            return static::$configurationManager;
        }
        if (\TYPO3\CMS\Core\Utility\VersionNumberUtility::convertVersionNumberToInteger(\TYPO3\CMS\Core\Utility\VersionNumberUtility::getNumericTypo3Version()) >= 11000000) {
            static::$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        } else {
            $objectManager = GeneralUtility::makeInstance(ObjectManager::class);
            static::$configurationManager = $objectManager->get(ConfigurationManagerInterface::class);
        }
        return static::$configurationManager;
    }

    protected static function getSettings(): array
    {
        if (static::$settings === null) {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );
            static::$settings = $all['plugin.']['tx_igcookies.']['settings.'] ?? [];
        }
        return static::$settings;
    }
}
