<?php

namespace Internetgalerie\IgCookies\Controller;

use Internetgalerie\IgCookies\Utility\ConfigUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Http\JsonResponse;

class ConsentController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * display banner to manage consents
     */
    public function bannerAction(): ResponseInterface
    {
        if (!ConfigUtility::isActive()) {
            return $this->htmlResponse('');
        }
        $configJsonPageUid = (int)($this->settings['configJsonPageUid'] ?? 0);
        if ($configJsonPageUid == 0) {
            $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');
            $configJsonPageUid = $site->getRootPageId();
        }
        $this->uriBuilder
            ->reset()
            ->setTargetPageUid($configJsonPageUid)
            ->setTargetPageType(1690140404);
        // v12
        if (method_exists($this, 'getRequest')) {
            $this->uriBuilder->setRequest($this->getRequest());
        }
        $configUrl = $this->uriBuilder->build();

        $this->view->assign('configUrl', $configUrl);

        return $this->htmlResponse($this->view->render());
    }


    /**
     * config action
     */
    public function configAction(): ResponseInterface
    {
        $response = ConfigUtility::getPurposesServices($this->settings);

        //return json_encode($response);
        return new JsonResponse($response);
    }
}
