<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgLanguageDetection\Utility\LanguageUtility;
use Internetgalerie\IgsCrm\Domain\Repository\ApiRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Context\LanguageAspectFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\View\JsonView;
use TYPO3\CMS\Extbase\Persistence\Repository;

abstract class AbstractApiController extends ActionController
{
    private static $excludeProperties = ['crdate','cruserId','t3verOid','t3verId','t3verWsid','t3verLabel','t3verState','t3verStage','t3verCount','t3verTstamp','t3verMoveId','l10nParent', 'l10nDiffsource','l10nState','starttime', 'endtime', 'deleted', 'tstamp', 'hidden'];

    /**
     * Repository for main data
     *
     * @var Repository
     */
    protected $dataRepository = null;

    /**
     * apiRepository
     *
     * @var ApiRepository
     */
    protected $apiRepository = null;


    /**
     * apiKey of request
     *
     * @var string
     */
    protected $apiKey = null;

    /**
     * api
     *
     * @var array
     */
    protected $api = [];

    /**
     * verband
     *
     * @var array
     */
    protected $verband = 0;

    public function __construct()
    {
        $this->language = static::getSiteLanguage();
        if ($this->language) {
            $languageAspect = LanguageAspectFactory::createFromSiteLanguage($this->language);

            $context = GeneralUtility::makeInstance(Context::class);
            $context->setAspect('language', $languageAspect);
        }
    }


    public function injectApiRepository(ApiRepository $apiRepository): void
    {
        $this->apiRepository = $apiRepository;
    }

    /**
     * set the output language accorging parameter 'language' or the header 'accept-language'
     * @return the choosen langauge or null if no language delivered/found
     */
    public static function getSiteLanguage()
    {
        $request = $GLOBALS['TYPO3_REQUEST'];
        $site = $request->getAttribute('site', null);

        $acceptLanguage = $_GET['language'] ?? $request->getHeader('accept-language')[0] ?? '';
        $siteLanguages = $site->getAllLanguages();
        $langIsoCodes = LanguageUtility::getAcceptedLanguages($acceptLanguage);
        if (!empty($siteLanguages)) {
            foreach ($langIsoCodes as $langIsoCode => $q) {
                $twoLetterIsoCode = substr($langIsoCode, 0, 2);
                foreach ($siteLanguages as $siteLanguage) {
                    if ($siteLanguage->getLocale()->getLanguageCode() == $twoLetterIsoCode) {
                        return $siteLanguage;
                    }
                }
            }
        }
        return null;
    }


    public function initializeAction(): void
    {
        $this->defaultViewObjectName = JsonView::class;
        $this->parseInput();
    }

    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
        $this->dataRepository->setToken($token);
        $datas = $this->dataRepository->findBy([
            'search' => $search,
        ]);
        $datas = $this->arrayUnderscoredToLowerCamelCase($datas);
        return $this->jsonResponse(
            (string)json_encode([
                    'meta' => [
                        'status' => 'success',
                    ],
                    'result' => $datas,

                ])
        );
    }



    protected function getSearch($setActive = true)
    {
        $search = [];
        if ($this->get['search']) {
            $search = array_merge($search, $this->get['search']);
            $search['showentries'] = true;
        } elseif ($this->request->hasArgument('search')) {
            $search = array_merge($search, $this->request->getArgument('search'));
        } else {
            $search = $this->searchDefault;
            /*
            if($this->settings['verbandUid']) {
                $search['verband'] = (int) $this->settings['verbandUid'] ;
            }
            */
        }
        //var_dump( $this->verband, $this->settings['verbandUid']);exit(0);
        $search['verband'] = $this->verband;

        if ($setActive && isset($search['verband']) && $search['verband'] > 0 && !isset($search['memberActive'])) {
            $search['memberActive'] = 1;
        }
        // remove __trustedProperteis etc.
        foreach ($search as $name => $value) {
            if (str_starts_with($name, '__')) {
                unset($search[$name]);
            }
        }
        return $search;
    }
    protected function arrayUnderscoredToLowerCamelCase($objectsUnderscored, $useObjectIdentifier = false)
    {
        $objects = [];
        foreach ($objectsUnderscored as $objectUnderscored) {
            $object = [];
            foreach ($objectUnderscored as $name => $value) {
                if ($useObjectIdentifier && $name === 'uid') {
                    $object['__identity'] = $value;
                } else { //if ($name !== 'type') {
                    $lowerCamelCase = GeneralUtility::underscoredToLowerCamelCase($name);
                    if (!in_array($lowerCamelCase, static::$excludeProperties)) {
                        $object[$lowerCamelCase] = $value;
                    }
                }
            }
            $objects[] = $object;
        }
        return $objects;
    }
    protected function underscoredToLowerCamelCase($objectUnderscored, $useObjectIdentifier = false)
    {
        $object = [];
        foreach ($objectUnderscored as $name => $value) {
            if ($useObjectIdentifier && $name === 'uid') {
                $object['__identity'] = $value;
            } else { //if ($name !== 'type') {
                    $lowerCamelCase = GeneralUtility::underscoredToLowerCamelCase($name);
                    if (!in_array($lowerCamelCase, static::$excludeProperties)) {
                        $object[$lowerCamelCase] = $value;
                    }
            }
        }
        return $object;
    }
    protected function parseInput()
    {
        $jsonData = json_decode((string)$this->request->getBody(), true);
        if (!is_array($jsonData)) {
            $jsonData = [];
        }
        $this->get = array_merge($_GET, $jsonData);
        if (isset($this->get['apiKey'])) {
            $this->apiKey = $this->get['apiKey'];
            $this->api = $this->apiRepository->getRawByApiKey($this->apiKey);
            $this->verband = $this->api['verband'] ?? 0;
        }
    }

}
