<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Utility\ContactUtility;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Messaging\FlashMessage;
use TYPO3\CMS\Core\Messaging\FlashMessageService;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class AbstractCrmController extends ActionController
{
    protected ?SecurityUtility $securityUtility = null;
    protected ?FlashMessageService $flashMessageService = null;

    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }

    public function injectFlashMessageService(FlashMessageService $flashMessageService): void
    {
        $this->flashMessageService = $flashMessageService;
    }

    public function assignCrm(): void
    {
        $this->view->assign('settings', $this->settings);
    }

    
    /**
     * Creates a Message object and adds it to the FlashMessageQueue.
     *
     * @param string $messageBody The message
     * @param string $messageTitle Optional message title
     * @param int $severity Optional severity, must be one of \TYPO3\CMS\Core\Messaging\FlashMessage constants
     * @param bool $storeInSession Optional, defines whether the message should be stored in the session (default) or not
     * @see \TYPO3\CMS\Core\Messaging\FlashMessage
     */
    public function addFlashMessage(
        $messageBody,
        $messageTitle = '',
        $severity = ContextualFeedbackSeverity::OK,
        $storeInSession = true
    ): void
    {
        $message = GeneralUtility::makeInstance(
            FlashMessage::class,
            $messageBody,
            $messageTitle,
            $severity,
            $storeInSession
        );
        $this->flashMessageService->getMessageQueueByIdentifier(ConfUtility::$flashMessageQueueIdentifier)->enqueue(
            $message
        );
    }

    protected function getControl()
    {
        return $this->request->hasArgument('control') ? $this->request->getArgument('control') : [];
    }
    protected function assignControl(array $control)
    {
        $this->view->assign('control', $control);
    }
    /**
     * Redirect to show page of the given Contact (works for Person/Organisation)
     *
     * @param Conact $contact a contact Person/Organisation
     * @param int $verbandId optional verband uid for Tab Link
     */
    protected function redirectToContact(Contact $contact, int $verbandId = null): ResponseInterface
    {
        $uri = ContactUtility::getShowUri($this->request, $contact, $this->settings, $verbandId);
        return $this->redirectToUri($uri);
    }
}
