<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Api;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\ApiRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;

class ApiController extends ActionController
{
    protected $objectClass = Api::class;
    /**
     * apiRepository
     *
     * @var ApiRepository
     */
    protected $apiRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectApiRepository(ApiRepository $apiRepository): void
    {
        $this->apiRepository = $apiRepository;
    }


    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'api',
    ])]
    public function newAction(Verband $verband, Api $api = null): ResponseInterface
    {
        $this->view->assign('api', $api);
        if ($api === null) {
            $defaultApiKey = 'CRM-' . SecurityUtility::generateRandomString(56);
            $this->view->assign('defaultApiKey', $defaultApiKey);
        }

        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'api',
    ])]
    public function editAction(Api $api, Verband $verband): ResponseInterface
    {
        $this->view->assign('api', $api);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Api $api, Verband $verband): ResponseInterface
    {
        $this->apiRepository->add($api);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Api $api, Verband $verband): ResponseInterface
    {
        $this->apiRepository->update($api);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'api',
    ])]
    public function confirmDeleteAction(Api $api, Verband $verband): ResponseInterface
    {
        $this->view->assign('api', $api);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Api $api, Verband $verband): ResponseInterface
    {
        $this->apiRepository->remove($api);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
}
