<?php

namespace Internetgalerie\IgCrmAdmin\Controller;
use TYPO3\CMS\Core\Database\Connection;

use Internetgalerie\IgsCrm\Domain\Repository\FrontendUserRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use PDO;
use Psr\Http\Message\ResponseInterface;

use TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class AuthApiController extends AbstractApiController
{
    /**
     * dataRepository
     *
     * @var PersonRepository
     */
    protected $dataRepository = null;

    /**
     * frontendUserRepository
     *
     * @var FrontendUserRepository
     */
    protected $frontendUserRepository = null;

    public function injectDataRepository(PersonRepository $dataRepository): void
    {
        $this->dataRepository = $dataRepository;
    }

    public function injectFrontendUserRepository(FrontendUserRepository $frontendUserRepository): void
    {
        $this->frontendUserRepository = $frontendUserRepository;
    }

    /**
     * action login
     */
    public function loginAction(): ResponseInterface
    {
        // https://documentation.commvault.com/v11/essential/45578_rest_api_authentication_post_login.html
        // $search = $this->getSearch() ?? [];
        $token = $this->get['apiKey'] ?? '';
        //$verband = $this->get['verband'] ?? null;

        $login = $this->get['login'] ?? [];
        $login['verband'] = $this->verband;
        //var_dump($token,$verband,$login);exit(0);
        $this->dataRepository->setToken($token);
        $datas = $this->dataRepository->findForAuth($login);
        $meta = [
            'status' => 'success',
        ];
        if ($datas === false) {
            $meta['error'] = 1;
            $meta['login'] = 'failed';
            $datas = [];
        } else {
            $meta['error'] = 0;
            $meta['login'] = 'success';
            $datas = $this->underscoredToLowerCamelCase($datas);
        }
        return $this->jsonResponse((string)json_encode([
                    'meta' => $meta,
                    'result' => $datas,
                ]));
    }

    /**
     * action show
     */
    public function showAction(): ResponseInterface
    {
        $email = $this->get['email'] ?? [];
        $person = $this->dataRepository->findOneByFrontendUserUsername($email);

        $error = false;
        if (!$person) {
            $error = true;
        }


        $this->view->setVariablesToRender(['json']);
        if ($error) {
            $this->view->assign('json', [
                'error' => $error,
            ]);
        } else {
            $this->view->assign('json', [
                'person' => $person,
                'user' => $person->getFrontendUser(),
            ]);
        }
        return $this->jsonResponse($this->view->render());
    }

    /**
     * action show
     */
    public function passwordChangeAction(): ResponseInterface
    {
        $username = $this->get['user'] ?? [];
        $newPass = $this->get['newPass'] ?? [];

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
        $feUser = $queryBuilder->select('*')
                      ->from('fe_users')
                      ->where($queryBuilder->expr()->eq('username', $queryBuilder->createNamedParameter($username)))
                      ->executeQuery()
                      ->fetchAssociative();
        $person = $queryBuilder->select('*')
            ->from('tx_igscrm_domain_model_contact')
            ->where($queryBuilder->expr()->eq('me_account', $queryBuilder->createNamedParameter($username)))
            ->executeQuery()
            ->fetchAssociative();
        $status = 'error';
        if ($feUser) {
            $status = 'success';
            //$user->setMePassword($newPass);
            //$this->dataRepository->update($user);

            $hashInstance = GeneralUtility::makeInstance(PasswordHashFactory::class)->getDefaultHashInstance('FE');
            $hashedPassword = $hashInstance->getHashedPassword($newPass);

            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
            $queryBuilder->update('fe_users')
                ->set('password', $hashedPassword)
                ->where(
                    $queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter(
                        $feUser['uid'],
                        Connection::PARAM_INT
                    ))
                )
                ->executeStatement();
        }

        if ($person) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
            $queryBuilder->update('tx_igscrm_domain_model_contact')
                ->set('me_password', $newPass)
                ->where(
                    $queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter(
                        $person['uid'],
                        Connection::PARAM_INT
                    ))
                )
                ->executeStatement();
        }

        return $this->jsonResponse((string)json_encode([
            'status' => $status,
        ]));
    }
}
